/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.vit.jurassicreborn.common.blocks.entities.MachineItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MachineItemHandlerSideWrapper
implements IItemHandler {
    private final MachineItemStackHandler handler;
    private final Direction direction;

    public MachineItemHandlerSideWrapper(MachineItemStackHandler handler, Direction direction) {
        this.handler = handler;
        this.direction = direction;
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.allowsInsertion(slot, stack)) {
            return stack;
        }
        return this.handler.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.allowsExtraction(slot)) {
            return ItemStack.f_41583_;
        }
        return this.handler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (!this.allowsInsertion(slot, stack)) {
            return false;
        }
        return this.handler.isItemValid(slot, stack);
    }

    private boolean allowsInsertion(int slot, ItemStack stack) {
        if (this.direction == Direction.DOWN) {
            return false;
        }
        return this.handler.isInputSlot(slot) && this.handler.isItemValid(slot, stack);
    }

    private boolean allowsExtraction(int slot) {
        if (this.direction == Direction.UP) {
            return false;
        }
        return this.handler.isOutputSlot(slot);
    }
}

