/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.grinder;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.grinder.FossilGrinderMenu;
import net.vit.jurassicreborn.common.blocks.inventory.FossilGrinderItemHandler;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscItem;
import net.vit.jurassicreborn.common.util.api.GrindableItem;
import org.jetbrains.annotations.NotNull;

public class FossilGrinderBlockEntity
extends MachineBlockEntity
implements MenuProvider,
ItemHandlerBlockEntity {
    public static final int SLOTS = 12;
    public static final int[] INPUTS = new int[]{0, 1, 2, 3, 4, 5};
    public static final int[] OUTPUTS = new int[]{6, 7, 8, 9, 10, 11};
    public static final int PROCESS_TIME = 200;
    protected final FossilGrinderItemHandler machineItemStackHandler = FossilGrinderItemHandler.instance();
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            if (pIndex == 0) {
                return FossilGrinderBlockEntity.this.grindTime;
            }
            return 0;
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex == 0) {
                FossilGrinderBlockEntity.this.grindTime = pValue;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private int grindTime = 0;

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    public FossilGrinderBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FOSSIL_GRINDER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @Override
    public Tag getMachineData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("GrindTime", this.grindTime);
        return data;
    }

    @Override
    public void readMachineData(Tag machineData) {
        if (machineData instanceof CompoundTag) {
            CompoundTag dataTag = (CompoundTag)machineData;
            this.grindTime = dataTag.m_128451_("GrindTime");
        } else {
            this.grindTime = 0;
        }
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        for (int inputIndex = 0; inputIndex < 6; ++inputIndex) {
            ItemStack input = this.getItem(inputIndex);
            GrindableItem grindableItem = GrindableItem.getGrindableItem(input);
            if (grindableItem == null || !grindableItem.isGrindable(input)) continue;
            for (int outputIndex = 6; outputIndex < 12; ++outputIndex) {
                if (!this.getItem(outputIndex).m_41619_()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... inputs) {
        GrindableItem grindableItem;
        ItemStack output;
        int emptySlot;
        Random rand = new Random();
        ItemStack input = ItemStack.f_41583_;
        int index = 0;
        for (int inputIndex = 0; inputIndex < 6; ++inputIndex) {
            input = this.getItem(inputIndex);
            if (input.m_41619_()) continue;
            index = inputIndex;
            break;
        }
        if (!input.m_41619_() && (emptySlot = this.getOutputSlot(output = (grindableItem = GrindableItem.getGrindableItem(input)).getGroundItem(input, rand))) != -1) {
            this.mergeStack(emptySlot, output);
            this.decreaseStackSize(index);
        }
        return List.of(ItemStack.f_41583_);
    }

    public static void copyDNA(ItemStack from, ItemStack to) {
        CompoundTag in = from.m_41783_();
        if (in != null && in.m_128441_("DNA")) {
            CompoundTag out = to.m_41784_();
            out.m_128365_("DNA", (Tag)in.m_128469_("DNA").m_6426_());
            to.m_41751_(out);
            StorageDiscItem.applyCustomModelData(to);
        }
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.fossil_grinder");
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, Player player) {
        return new FossilGrinderMenu(pContainerId, pInventory, this.machineItemStackHandler, this.data);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FossilGrinderBlockEntity pBlockEntity) {
        boolean isWorking = pBlockEntity.grindTime > 0;
        boolean hasInputs = pBlockEntity.hasInputs();
        if (pLevel.f_46443_) {
            return;
        }
        if (!hasInputs && isWorking) {
            pBlockEntity.grindTime = 0;
            pBlockEntity.m_6596_();
            return;
        }
        if (hasInputs && pBlockEntity.canProcess(new ItemStack[0])) {
            ++pBlockEntity.grindTime;
            if (pBlockEntity.grindTime >= 200) {
                pBlockEntity.grindTime = 0;
                pBlockEntity.processItem(new ItemStack[0]);
            }
        }
    }

    public boolean hasInputs() {
        for (int i : INPUTS) {
            if (this.getItem(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void mergeStack(int slot, ItemStack stack) {
        ItemStack previous = this.getItem(slot);
        if (previous.m_41619_()) {
            this.setItem(slot, stack);
        } else if (ItemStack.m_41746_((ItemStack)previous, (ItemStack)stack) && ItemStack.m_41746_((ItemStack)previous, (ItemStack)stack)) {
            previous.m_41764_(previous.m_41613_() + stack.m_41613_());
        }
    }

    protected void decreaseStackSize(int slot) {
        this.getItem(slot).m_41774_(1);
        if (this.getItem(slot).m_41613_() <= 0) {
            this.setItem(slot, ItemStack.f_41583_);
        }
    }

    public int getOutputSlot(ItemStack output) {
        for (int slot : OUTPUTS) {
            ItemStack stack = this.getItem(slot);
            if (!stack.m_41619_() && (!ItemStack.m_41746_((ItemStack)stack, (ItemStack)output) || stack.m_41613_() + output.m_41613_() > stack.m_41741_() || stack.m_41720_() != output.m_41720_() || stack.m_41773_() != output.m_41773_())) continue;
            return slot;
        }
        return -1;
    }
}

