/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AchillobatorEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class AchillobatorDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public AchillobatorDinosaur() {
        this.setName("Achillobator");
        this.setScientificName("Achillobator giganticus");
        this.setFamily("Dromaeosauridae");
        this.setLocation("Mongolia");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(AchillobatorEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(8024680, 8276289);
        this.setEggColorFemale(14802908, 6773848);
        this.setHealth(6.0, 40.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStorage(27);
        this.setStrength(2.0, 10.0);
        this.setAttackBias(1200.0);
        this.setAttackSpeed(1.9);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.45f, 1.75f);
        this.setSizeX(0.5f, 1.0f);
        this.setSizeY(0.5f, 1.8f);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("arm_bones", "foot_bones", "leg_bones", "neck_vertebrae", "ribcage", "shoulder", "skull", "claw", "pelvis", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(1.3f, 0.2f);
        this.setBreeding(false, 2, 4, 30, false, true);
        this.setMaxHerdSize(10);
        this.setCanClimb(true);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setStorage(27);
        this.setJumpHeight(3);
        this.shouldDefendOffspring();
        String[][] recipe = new String[][]{{"", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "ribcage", "shoulder", "tooth"}, {"leg_bones", "leg_bones", "arm_bones", "claw"}, {"foot_bones", "foot_bones", "", ""}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_DENSE, BiomeTags.f_207611_, BiomeTags.f_215816_, BiomeTags.f_207610_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.doSkeletonCheck();
    }

    protected void doSkeletonCheck() {
        this.enableSkeleton();
    }
}

