/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CamarasaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class CamarasaurusDinosaur
extends Dinosaur {
    public static final double SPEED = 0.25;

    public CamarasaurusDinosaur() {
        this.setName("Camarasaurus");
        this.setScientificName("Camarasaurus grandis");
        this.setFamily("Camarasauridae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(CamarasaurusEntity.class);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(9153150, 9324338);
        this.setEggColorFemale(12235922, 9018789);
        this.setHealth(10.0, 65.0);
        this.setSpeed(0.2, 0.25);
        this.setStorage(52);
        this.setDiet(Diet.HERBIVORE.get());
        this.setStrength(5.0, 40.0);
        this.setMaximumAge(this.fromDays(95));
        this.setEyeHeight(0.45f, 3.95f);
        this.setSizeX(0.4f, 5.4f);
        this.setSizeY(0.5f, 5.8f);
        this.setBones("skull", "tooth", "front_leg_bones", "hind_leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(1.15f, 0.1f);
        this.setPaleoPadScale(5.0f);
        this.shouldDefendOffspring();
        this.setAttackBias(1500.0);
        this.setBreeding(false, 4, 8, 80, false, true);
        String[][] recipe = new String[][]{{"", "", "", "", "skull"}, {"", "", "", "neck_vertebrae", "tooth"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", ""}, {"", "hind_leg_bones", "hind_leg_bones", "front_leg_bones", "front_leg_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_215816_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

