/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CorythosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class CorythosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.41f;

    public CorythosaurusDinosaur() {
        this.setName("Corythosaurus");
        this.setScientificName("Corythosaurus casuarius");
        this.setFamily("Hadrosauridae");
        this.setLocation("Canada");
        this.setDinosaurType(Dinosaur.DinosaurType.PASSIVE);
        this.setDinosaurClass(CorythosaurusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(12232830, 6189569);
        this.setEggColorFemale(11772541, 15318855);
        this.setHealth(10.0, 56.0);
        this.setSpeed(0.3599999964237213, 0.41f);
        this.setStrength(5.0, 15.0);
        this.setMaximumAge(this.fromDays(40));
        this.setAttackBias(50.0);
        this.setEyeHeight(0.45f, 3.45f);
        this.setSizeX(0.5f, 2.5f);
        this.setSizeY(0.8f, 3.5f);
        this.setStorage(36);
        this.setAttackBias(12.0);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("cheek_teeth", "front_leg_bones", "neck_vertebrae", "hind_leg_bones", "pelvis", "shoulder", "skull", "tail_vertebrae", "ribcage");
        this.setHeadCubeName("Head");
        this.setScale(1.0f, 0.05f);
        this.setImprintable(true);
        this.setFlockSpeed(1.5f);
        this.setBreeding(false, 2, 6, 40, false, true);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"hind_leg_bones", "hind_leg_bones", "", "shoulder", "cheek_teeth"}, {"", "", "", "front_leg_bones", "front_leg_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_215816_, BiomeTags.f_207607_, Tags.Biomes.IS_SANDY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.setSpawn(1, biomeList);
        this.init();
    }
}

