/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.KairukuEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class KairukuDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.18f;

    public KairukuDinosaur() {
        this.setName("Kairuku");
        this.setScientificName("Kairuku grebneffi");
        this.setFamily("Spheniscidae");
        this.setLocation("New Zealand");
        this.setDinosaurType(Dinosaur.DinosaurType.PASSIVE);
        this.setDinosaurClass(KairukuEntity.class);
        this.setTimePeriod(TimePeriod.PALEOGENE);
        this.setEggColorMale(0x252522, 14206902);
        this.setEggColorFemale(0x1F1F1D, 15789803);
        this.setHealth(6.0, 20.0);
        this.setSpeed(0.13000000715255738, 0.18f);
        this.setStorage(27);
        this.setStrength(1.0, 6.0);
        this.setMaximumAge(this.fromDays(40));
        this.setEyeHeight(0.3f, 0.9f);
        this.setSizeX(0.2f, 0.9f);
        this.setSizeY(0.4f, 1.1f);
        this.setDiet(Diet.PISCIVORE.get());
        this.setBones("skull", "arm_bones", "leg_bones", "neck_vertebrae", "ribcage", "shoulder", "tail_vertebrae", "foot_bones");
        this.setHeadCubeName("Head");
        this.setScale(0.5f, 0.1f);
        this.setAttackBias(10.0);
        this.setAttackSpeed(0.8f);
        this.setDefendOwner(false);
        this.setBirthType(Dinosaur.BirthType.EGG_LAYING);
        this.setImprintable(true);
        this.setBreeding(false, 1, 2, 24, false, true);
        String[][] recipe = new String[][]{{"skull", "neck_vertebrae", "", ""}, {"arm_bones", "ribcage", "shoulder", ""}, {"", "leg_bones", "tail_vertebrae", ""}, {"", "foot_bones", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207603_, BiomeTags.f_207604_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

