/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TyrannosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class TyrannosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.42f;

    public TyrannosaurusDinosaur() {
        this.setName("Tyrannosaurus");
        this.setScientificName("Tyrannosaurus rex");
        this.setFamily("Tyrannosauridae");
        this.setLocation("United States");
        this.setDinosaurClass(TyrannosaurusEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(5132332, 3487537);
        this.setEggColorFemale(12228990, 8215880);
        this.setHealth(10.0, 80.0);
        this.setSpeed(0.36999998688697816, 0.42f);
        this.setAttackSpeed(1.3);
        this.setStrength(2.0, 25.0);
        this.setMaximumAge(this.fromDays(60));
        this.setEyeHeight(0.35f, 3.5f);
        this.setSizeX(0.2f, 3.0f);
        this.setSizeY(0.4f, 3.6f);
        this.setStorage(54);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("arm_bones", "foot_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(2.4f, 0.1f);
        this.setMaxHerdSize(4);
        this.setAttackBias(1000.0);
        this.setBreeding(false, 2, 4, 60, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", "tooth"}, {"", "leg_bones", "leg_bones", "arm_bones", ""}, {"", "foot_bones", "foot_bones", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

