/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.sounds.CarLoopSound;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.vehicle.CarWheel;
import net.vit.jurassicreborn.common.entities.vehicle.InterpValue;
import net.vit.jurassicreborn.common.entities.vehicle.WheelParticleData;
import net.vit.jurassicreborn.common.network.CarEntityPlayRecord;
import net.vit.jurassicreborn.common.network.Network;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public abstract class VehicleEntity
extends Entity {
    public static final EntityDataAccessor<Byte> WATCHER_STATE = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Float> WATCHER_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> WATCHER_SPEED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<ItemStack> RECORD_ITEM = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<CompoundTag> WATCHER_SEATS = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final float MAX_HEALTH = 40.0f;
    private static final byte LEFT = 1;
    private static final byte RIGHT = 2;
    private static final byte FORWARD = 4;
    private static final byte BACKWARD = 8;
    private float wheelFrameProgress;
    protected final Seat[] seats = this.createSeats();
    protected final WheelData wheeldata = this.createWheels();
    public float wheelRotation;
    public float wheelRotateAmount;
    public float prevWheelRotateAmount;
    public InterpValue steerAmount;
    public float pitch;
    public float roll;
    protected float rotationDelta;
    private boolean noiseInstance;
    public int interpProgress;
    double interpTargetX;
    public double interpTargetY;
    public double interpTargetZ;
    public double interpTargetYaw;
    public float speedModifier = 0.0f;
    private static final double INTERP_AMOUNT = 0.15;
    public boolean wasOnGroundLastTick;
    private Vec3 prevUnairbornPos;
    public final InterpValue backValue = new InterpValue(this, 0.15);
    public final InterpValue frontValue = new InterpValue(this, 0.15);
    public final InterpValue leftValue = new InterpValue(this, 0.15);
    public final InterpValue rightValue = new InterpValue(this, 0.15);
    public final CarWheel backLeftWheel;
    public final CarWheel backRightWheel;
    public final CarWheel frontLeftWheel;
    public final CarWheel frontRightWheel;
    public final List<WheelParticleData>[] wheelDataList;
    public List<CarWheel> allWheels;
    @OnlyIn(value=Dist.CLIENT)
    public CarLoopSound engineSound;
    private static final Item[] STATIONS = new Item[]{Items.f_42752_, Items.f_42701_, Items.f_220217_, Items.f_42710_, Items.f_42752_, Items.f_42702_, Items.f_42703_, Items.f_42705_, Items.f_42706_, Items.f_186363_, Items.f_42712_, Items.f_42707_, Items.f_42708_, Items.f_42711_, Items.f_42709_, Items.f_42704_};
    private float healAmount;
    private int healCooldown;
    private Vec3 previousPosition;
    private long prevWorldTime;
    public double estimatedSpeed;
    private byte prevState;
    private boolean didDieOnce;

    public VehicleEntity(EntityType<? extends VehicleEntity> type, Level world) {
        super(type, world);
        this.backLeftWheel = new CarWheel(0, this.wheeldata.bl);
        this.backRightWheel = new CarWheel(1, this.wheeldata.br);
        this.frontLeftWheel = new CarWheel(2, this.wheeldata.fl);
        this.frontRightWheel = new CarWheel(3, this.wheeldata.fr);
        this.wheelDataList = new List[4];
        this.allWheels = Lists.newArrayList((Object[])new CarWheel[]{this.backLeftWheel, this.frontLeftWheel, this.backRightWheel, this.frontRightWheel});
        this.healCooldown = 40;
        this.previousPosition = null;
        this.prevWorldTime = -1L;
        this.estimatedSpeed = 0.0;
        this.prevState = 0;
        this.didDieOnce = false;
        this.m_20011_(new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 3.0, this.m_20186_() + 2.5, this.m_20189_() + 3.0));
        this.f_19793_ = 1.5f;
        if (world.f_46443_) {
            this.steerAmount = new InterpValue(this, 0.1);
        }
        for (int i = 0; i < 4; ++i) {
            this.wheelDataList[i] = Lists.newArrayList();
        }
        this.backLeftWheel.setPair(this.backRightWheel);
        this.frontLeftWheel.setPair(this.frontRightWheel);
    }

    protected abstract void dropFromLootTable(boolean var1);

    protected void dropRecordedItemOrLoot(boolean causedByPlayer) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        ItemStack record = this.getItem();
        if (!record.m_41619_()) {
            this.m_19983_(record);
        } else {
            this.dropFromLootTable(causedByPlayer);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(WATCHER_STATE, (Object)0);
        this.f_19804_.m_135372_(WATCHER_HEALTH, (Object)Float.valueOf(40.0f));
        this.f_19804_.m_135372_(WATCHER_SPEED, (Object)1);
        this.f_19804_.m_135372_(RECORD_ITEM, (Object)ItemStack.f_41583_);
        CompoundTag s = new CompoundTag();
        for (int i = 0; i < this.createSeats().length; ++i) {
            s.m_128359_(this.str(i), "");
        }
        this.f_19804_.m_135372_(WATCHER_SEATS, (Object)s);
    }

    public boolean left() {
        return this.getStateBit((byte)1);
    }

    public boolean right() {
        return this.getStateBit((byte)2);
    }

    public boolean forward() {
        return this.getStateBit((byte)4);
    }

    public boolean backward() {
        return this.getStateBit((byte)8);
    }

    public void left(boolean b) {
        this.setStateBit((byte)1, b);
    }

    public void right(boolean b) {
        this.setStateBit((byte)2, b);
    }

    public void forward(boolean b) {
        this.setStateBit((byte)4, b);
    }

    public void backward(boolean b) {
        this.setStateBit((byte)8, b);
    }

    protected boolean getStateBit(byte mask) {
        return (this.getControlState() & mask) != 0;
    }

    protected void setStateBit(byte mask, boolean newState) {
        byte state = this.getControlState();
        this.setControlState((byte)(newState ? state | mask : state & ~mask));
    }

    public byte getControlState() {
        return (Byte)this.f_19804_.m_135370_(WATCHER_STATE);
    }

    public byte getPreviousState() {
        return this.prevState;
    }

    public void setControlState(byte state) {
        this.f_19804_.m_135381_(WATCHER_STATE, (Object)state);
    }

    public void setPreviousState(byte state) {
        this.prevState = state;
    }

    public void setSpeed(Speed speed) {
        this.f_19804_.m_135381_(WATCHER_SPEED, (Object)speed.ordinal());
    }

    public Speed getSpeed() {
        return Speed.values()[(Integer)this.f_19804_.m_135370_(WATCHER_SPEED)];
    }

    public void setHealth(float health) {
        this.f_19804_.m_135381_(WATCHER_HEALTH, (Object)Float.valueOf(health));
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(WATCHER_HEALTH)).floatValue();
    }

    public ItemStack getItem() {
        return (ItemStack)this.f_19804_.m_135370_(RECORD_ITEM);
    }

    public void setItem(ItemStack stack) {
        this.f_19804_.m_135381_(RECORD_ITEM, (Object)stack.m_41777_());
    }

    public boolean m_6783_(double dist) {
        return true;
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.seats.length;
    }

    @Nullable
    public Entity m_6688_() {
        String id = this.getIfExists(0, false);
        if (id.equals("")) {
            return null;
        }
        try {
            int entityId = Integer.parseInt(id);
            return this.f_19853_.m_6815_(entityId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public Entity getEntityInSeat(int seatID) {
        String id = this.getIfExists(seatID, false);
        if (id.equals("")) {
            return null;
        }
        try {
            int entityId = Integer.parseInt(id);
            return this.f_19853_.m_6815_(entityId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float pitch(float partialTicks) {
        return this.pitch;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float roll(float partialTicks) {
        return this.roll;
    }

    public String getIfExists(int seatID, boolean reset) {
        String string = ((CompoundTag)this.f_19804_.m_135370_(WATCHER_SEATS)).m_128461_(this.str(seatID));
        if (!string.equals("")) {
            Entity entity = null;
            try {
                entity = this.f_19853_.m_6815_(Integer.parseInt(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entity == null || entity.m_20202_() != this) {
                if (reset) {
                    this.setSeat(this.str(seatID), "");
                }
                return "";
            }
            return string;
        }
        return "";
    }

    public boolean m_6087_() {
        return true;
    }

    public Vector4f getCarDimensions() {
        return this.wheeldata.carVector;
    }

    public Vec2 getBackWheelRotationPoint() {
        return new Vec2(-0.5f, 1.4f);
    }

    public void setPositionAndRotationDirect(double x, double y, double z, float yaw, float pitch, int duration) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpProgress = duration;
    }

    protected void doBlockCollisions() {
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        float damage;
        if (!this.f_19853_.f_46443_ && (damage = (float)Mth.m_14167_((float)((fallDistance - 3.0f) * damageMultiplier))) > 0.0f) {
            this.setHealth(this.getHealth() - damage * 1.25f);
            this.checkAndHandleDeath();
        }
        return false;
    }

    protected double calculateWheelHeight(double distance, boolean rotate90) {
        Level lvl = this.f_19853_;
        float localYaw = this.f_19859_ + (this.m_146908_() - this.f_19859_);
        double bestY = this.m_20186_() - 4.0;
        Vector4f carVec = this.wheeldata.carVector;
        double side = Math.abs(rotate90 ? carVec.x() - carVec.z() : carVec.z() - carVec.w());
        for (double d = -side; d <= side; d += 0.25) {
            double xRot = Math.sin(Math.toRadians(localYaw)) * (rotate90 ? d : distance) - Math.cos(Math.toRadians(localYaw)) * (rotate90 ? distance : d);
            double zRot = -Math.cos(Math.toRadians(localYaw)) * (rotate90 ? d : distance) - Math.sin(Math.toRadians(localYaw)) * (rotate90 ? distance : d);
            Vec3 sample = new Vec3(this.m_20185_() + xRot, this.m_20186_(), this.m_20189_() + zRot);
            BlockPos pos = new BlockPos(Mth.m_14107_((double)sample.f_82479_), Mth.m_14107_((double)sample.f_82480_), Mth.m_14107_((double)sample.f_82481_));
            boolean found = false;
            double topY = Double.NEGATIVE_INFINITY;
            while (!found && pos.m_123342_() >= lvl.m_141937_()) {
                BlockState state = lvl.m_8055_(pos);
                VoxelShape shape = state.m_60812_((BlockGetter)lvl, pos);
                if (state.m_60795_() || shape.m_83281_()) {
                    pos = pos.m_7495_();
                    continue;
                }
                topY = (double)pos.m_123342_() + shape.m_83297_(Direction.Axis.Y);
                found = true;
            }
            if (!found) {
                bestY = Math.max(bestY, this.m_20186_());
                continue;
            }
            BlockPos above = pos.m_7494_();
            BlockPos above2 = pos.m_6630_(2);
            bestY = !lvl.m_8055_(above).m_60795_() || !lvl.m_8055_(above2).m_60795_() ? Math.max(bestY, this.m_20186_()) : Math.max(bestY, topY);
        }
        return bestY;
    }

    protected void handleControl() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && !this.noiseInstance) {
            this.noiseInstance = true;
            this.startSound();
        }
        this.checkAndHandleDeath();
        if (this.healCooldown > 0) {
            --this.healCooldown;
        } else if (this.healAmount > 0.0f) {
            this.setHealth(this.getHealth() + 1.0f);
            this.healAmount -= 1.0f;
            if (this.getHealth() > 40.0f) {
                this.setHealth(40.0f);
                this.healAmount = 0.0f;
            }
        }
        if (this.previousPosition == null) {
            this.previousPosition = this.m_20182_();
        }
        this.estimatedSpeed = this.previousPosition.m_82554_(this.m_20182_()) / (double)(this.f_19853_.m_46467_() - this.prevWorldTime + 1L);
        this.previousPosition = this.m_20182_();
        this.prevWorldTime = this.f_19853_.m_46467_();
        for (int i = 0; i < 4; ++i) {
            ArrayList markedRemoved = Lists.newArrayList();
            this.wheelDataList[i].forEach(wheel -> wheel.onUpdate(markedRemoved));
            markedRemoved.forEach(this.wheelDataList[i]::remove);
        }
        this.allWheels.forEach(this::processWheel);
        this.spawnWheelParticles();
        Vector4f vec = this.wheeldata.carVector;
        this.backValue.setTarget(this.calculateWheelHeight(vec.y(), false));
        this.frontValue.setTarget(this.calculateWheelHeight(vec.w(), false));
        this.leftValue.setTarget(this.calculateWheelHeight(vec.z(), true));
        this.rightValue.setTarget(this.calculateWheelHeight(vec.x(), true));
        this.tickInterp();
        this.updateMotion();
        if (this.m_20197_().isEmpty() || !(this.m_20197_().get(0) instanceof Player)) {
            this.setControlState((byte)0);
        }
        if (this.f_19853_.f_46443_) {
            this.handleControl();
        }
        this.updateWheelSpin();
        this.advanceInterpolations();
        this.applyMovement();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.updateWheelSpin();
        if (this.f_19853_.f_46443_) {
            this.updateSeatAnimations();
        }
        this.clientAnimate();
    }

    protected void updateMotion() {
        double resist = 0.8f;
        this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        this.rotationDelta = (float)((double)this.rotationDelta * (double)0.8f);
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.15f, 0.0));
        }
    }

    private void updateWheelSpin() {
        this.prevWheelRotateAmount = this.wheelRotateAmount;
        double dx = this.m_20185_() - this.f_19790_;
        double dz = this.m_20189_() - this.f_19792_;
        double dist = Math.sqrt(dx * dx + dz * dz);
        float delta = (float)(dist * 0.35 * 360.0);
        this.wheelRotateAmount = Mth.m_14179_((float)0.4f, (float)this.wheelRotateAmount, (float)delta);
        this.wheelRotation += this.wheelRotateAmount;
    }

    private void updateSeatAnimations() {
        for (Seat seat : this.seats) {
            seat.getInterpValue().tick();
        }
    }

    protected void applyMovement() {
        Speed speed = this.getSpeed();
        float moveAmount = 0.0f;
        if ((this.left() || this.right()) && !this.forward() && !this.backward()) {
            moveAmount += 0.05f;
        }
        if (this.forward()) {
            moveAmount += 0.1f;
        } else if (this.backward()) {
            moveAmount -= 0.05f;
        }
        moveAmount *= speed.modifier + this.speedModifier;
        if (this.m_20069_() && (moveAmount -= 0.1f) < 0.0f) {
            moveAmount = 0.0f;
        }
        if (this.left()) {
            this.rotationDelta -= 20.0f * moveAmount;
        } else if (this.right()) {
            this.rotationDelta += 20.0f * moveAmount;
        }
        this.rotationDelta = Mth.m_14036_((float)this.rotationDelta, (float)-3.0f, (float)3.0f);
        this.m_146922_(this.m_146908_() + this.rotationDelta);
        this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * moveAmount), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * moveAmount)));
    }

    private void handleDeath(@Nullable Entity killer) {
        if (this.f_19853_.f_46443_ || this.didDieOnce || this.m_213877_()) {
            return;
        }
        this.didDieOnce = true;
        boolean causedByPlayer = killer instanceof Player;
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.dropRecordedItemOrLoot(causedByPlayer);
        }
        this.m_146870_();
    }

    private void checkAndHandleDeath() {
        if (!this.f_19853_.f_46443_ && this.getHealth() <= 0.0f) {
            this.handleDeath(null);
        }
    }

    private void tickInterp() {
        if (this.interpProgress > 0 && !this.m_6109_()) {
            double interpolatedX = this.m_20185_() + (this.interpTargetX - this.m_20185_()) / (double)this.interpProgress;
            double interpolatedY = this.m_20186_() + (this.interpTargetY - this.m_20186_()) / (double)this.interpProgress;
            double interpolatedZ = this.m_20189_() + (this.interpTargetZ - this.m_20189_()) / (double)this.interpProgress;
            double deltaYaw = Mth.m_14175_((double)(this.interpTargetYaw - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + deltaYaw / (double)this.interpProgress));
            --this.interpProgress;
            this.m_6034_(interpolatedX, interpolatedY, interpolatedZ);
        }
    }

    protected boolean canPassengerSteer() {
        Entity entity = this.m_6688_();
        return entity instanceof Player;
    }

    private void clientAnimate() {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        for (Seat seat : this.seats) {
            seat.getInterpValue().update();
        }
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        int seatId = this.getSeatForEntity(passenger);
        Seat seat = seatId >= 0 ? this.seats[seatId] : null;
        double baseY = this.m_20186_() + this.m_6048_() / 5.0;
        double px = this.m_20185_();
        double py = baseY + passenger.m_6049_();
        double pz = this.m_20189_();
        if (seat != null) {
            Vec3 seatPos = seat.getPos(this);
            px = seatPos.f_82479_;
            py = baseY + (double)seat.getOffsetY() + passenger.m_6049_();
            pz = seatPos.f_82481_;
        }
        passenger.m_6034_(px, py, pz);
        passenger.m_146922_(passenger.m_146908_() + this.rotationDelta);
        passenger.m_5616_(passenger.m_6080_() + this.rotationDelta);
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            living.f_20883_ += this.rotationDelta;
        }
    }

    protected void m_20351_(Entity passenger) {
        this.m_7332_(passenger);
        this.m_146867_();
        this.interpTargetX = this.m_20185_();
        this.interpTargetY = this.m_20186_();
        this.interpTargetZ = this.m_20189_();
        this.interpTargetYaw = this.m_146908_();
        this.interpProgress = 0;
        if (!this.f_19853_.f_46443_) {
            ((ServerLevel)this.f_19853_).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundTeleportEntityPacket((Entity)this));
        }
        int seat = this.getSeatForEntity(passenger);
        super.m_20351_(passenger);
        if (seat != -1) {
            this.setSeat(Integer.toString(seat), "");
        }
        passenger.f_19794_ = false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            if (source.m_7639_() instanceof Player) {
                this.healAmount += (amount *= 10.0f);
                this.healCooldown = 40;
            }
            this.setHealth(this.getHealth() - amount);
            if (this.getHealth() <= 0.0f) {
                this.handleDeath(source.m_7639_());
            }
        }
        return true;
    }

    protected void m_7378_(CompoundTag compound) {
        this.setHealth(compound.m_128457_("Health"));
        this.healAmount = compound.m_128457_("HealAmount");
        this.setSpeed(Speed.values()[compound.m_128451_("Speed")]);
        CompoundTag tag = compound.m_128469_("InterpValues");
        this.backValue.deserializeNBT(tag.m_128469_("Back"));
        this.frontValue.deserializeNBT(tag.m_128469_("Front"));
        this.leftValue.deserializeNBT(tag.m_128469_("Left"));
        this.rightValue.deserializeNBT(tag.m_128469_("Right"));
        this.f_19804_.m_135381_(RECORD_ITEM, (Object)ItemStack.m_41712_((CompoundTag)compound.m_128469_("RecordItem")));
    }

    private void advanceInterpolations() {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        if (this.steerAmount != null) {
            this.steerAmount.tick();
        }
        for (Seat s : this.seats) {
            s.getInterpValue().tick();
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("Health", this.getHealth());
        compound.m_128350_("HealAmount", this.healAmount);
        compound.m_128405_("Speed", this.getSpeed().ordinal());
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Back", (Tag)this.backValue.serializeNBT());
        tag.m_128365_("Front", (Tag)this.frontValue.serializeNBT());
        tag.m_128365_("Left", (Tag)this.leftValue.serializeNBT());
        tag.m_128365_("Right", (Tag)this.rightValue.serializeNBT());
        compound.m_128365_("InterpValues", (Tag)tag);
        compound.m_128365_("RecordItem", (Tag)((ItemStack)this.f_19804_.m_135370_(RECORD_ITEM)).m_41739_(new CompoundTag()));
    }

    private String str(int input) {
        return Integer.toString(input);
    }

    public void setSeat(String seatID, String uuid) {
        CompoundTag comp = ((CompoundTag)this.f_19804_.m_135370_(WATCHER_SEATS)).m_6426_();
        comp.m_128359_(seatID, uuid);
        this.f_19804_.m_135381_(WATCHER_SEATS, (Object)comp);
    }

    public boolean tryPutInSeat(Entity passenger, int seatID, boolean isPacket) {
        int seatNumber;
        if (seatID < this.seats.length && seatID >= 0 && ((seatNumber = this.getSeatForEntity(passenger)) == 0 && seatID == 0 && !isPacket || this.getIfExists(seatID, false).equals(""))) {
            if (seatNumber != -1) {
                this.setSeat(this.str(seatNumber), "");
            }
            this.setSeat(this.str(seatID), this.str(passenger.m_19879_()));
            return true;
        }
        return false;
    }

    @Nullable
    public int getSeatForEntity(Entity entity) {
        for (int i = 0; i < this.seats.length; ++i) {
            if (!this.getIfExists(i, true).equals(this.str(entity.m_19879_()))) continue;
            return i;
        }
        return -1;
    }

    public Seat getSeat(int id) {
        if (id < this.seats.length) {
            return this.seats[id];
        }
        return null;
    }

    public int getSeatCount() {
        return this.seats.length;
    }

    public void cycleSeat(Entity passenger) {
        int current = this.getSeatForEntity(passenger);
        if (current == -1) {
            return;
        }
        int next = (current + 1) % this.seats.length;
        if (this.tryPutInSeat(passenger, next, false)) {
            passenger.m_7998_((Entity)this, true);
        }
    }

    public void cycleStation() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        ItemStack current = this.getItem();
        int idx = -1;
        for (int i = 0; i < STATIONS.length; ++i) {
            if (!current.m_150930_(STATIONS[i])) continue;
            idx = i;
            break;
        }
        int next = (idx + 1) % STATIONS.length;
        ItemStack record = new ItemStack((ItemLike)STATIONS[next]);
        this.f_19804_.m_135381_(RECORD_ITEM, (Object)record);
        Network.sendToAllNear(this.f_19853_, this.m_20183_(), new CarEntityPlayRecord(this.m_19879_(), record));
    }

    protected void processWheel(CarWheel wheel) {
        float localYaw = this.m_146908_();
        Vec2 relPos = wheel.getRelativeWheelPosition();
        double xRot = Math.sin(Math.toRadians(localYaw)) * (double)relPos.f_82471_ - Math.cos(Math.toRadians(localYaw)) * (double)relPos.f_82470_;
        double zRot = -Math.cos(Math.toRadians(localYaw)) * (double)relPos.f_82471_ - Math.sin(Math.toRadians(localYaw)) * (double)relPos.f_82470_;
        Vec3 vec = new Vec3(this.m_20185_() + xRot, this.m_20186_(), this.m_20189_() + zRot);
        int groundY = this.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mth.m_14107_((double)vec.f_82479_), Mth.m_14107_((double)vec.f_82481_)) - 1;
        Vec3 groundPos = new Vec3(vec.f_82479_, (double)groundY, vec.f_82481_);
        wheel.setCurrentWheelPos(groundPos);
    }

    protected void spawnWheelParticles() {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        for (CarWheel wheel : this.allWheels) {
            boolean allowed;
            CarWheel opposite = wheel.getOppositeWheel();
            if (opposite == null) continue;
            Vec3 groundPos = wheel.getCurrentWheelPos();
            BlockPos pos = new BlockPos(groundPos.f_82479_, groundPos.f_82480_, groundPos.f_82481_);
            BlockState ground = this.f_19853_.m_8055_(pos);
            boolean bl = allowed = (ground.m_60767_() == Material.f_76315_ || ground.m_60767_() == Material.f_76314_ || ground.m_60767_() == Material.f_76317_) && ground.m_60783_((BlockGetter)this.f_19853_, pos, Direction.UP) && this.f_19853_.m_8055_(pos.m_7494_()).m_60767_() != Material.f_76305_;
            if (!allowed) continue;
            Vec3 opp = opposite.getCurrentWheelPos();
            int oppGroundY = this.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mth.m_14107_((double)opp.f_82479_), Mth.m_14107_((double)opp.f_82481_)) - 1;
            Vec3 oppGroundPos = new Vec3(opp.f_82479_, (double)oppGroundY, opp.f_82481_);
            this.wheelDataList[wheel.getID()].add(new WheelParticleData(groundPos, oppGroundPos, this.f_19853_.m_46467_()));
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            if (player.m_20202_() == this) {
                return InteractionResult.CONSUME;
            }
            int seat = this.getSeatForEntity((Entity)player);
            if (seat == -1) {
                for (int i = 0; i < this.seats.length; ++i) {
                    if (!this.getIfExists(i, false).equals("")) continue;
                    seat = i;
                    break;
                }
            }
            if (seat != -1 && this.tryPutInSeat((Entity)player, seat, false)) {
                player.m_7998_((Entity)this, true);
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSoundVolume() {
        return (Math.abs(this.wheelRotateAmount) + 0.001f) / (this.engineSound == null || this.engineSound.m_7801_() ? 2.0f : 4.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSound() {
        if (this.engineSound == null) {
            this.engineSound = new CarLoopSound(this, SoundHandler.CAR_MOVE, SoundSource.RECORDS, v -> !v.m_213877_());
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.engineSound);
        }
    }

    protected abstract Seat[] createSeats();

    protected abstract WheelData createWheels();

    public abstract void dropItems();

    public static final class Seat {
        private final InterpValue interpValue = new InterpValue(() -> true, 0.1);
        private float offsetX;
        private float offsetY;
        private float offsetZ;
        private final float radius;
        private final float height;

        public Seat(float offsetX, float offsetY, float offsetZ, float radius, float height) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.radius = radius;
            this.height = height;
        }

        public void setOffsets(float x, float y, float z) {
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
        }

        public Vec3 getPos(VehicleEntity car) {
            double theta = Math.toRadians(car.m_146908_());
            double sideX = Math.cos(theta);
            double sideZ = Math.sin(theta);
            double fTheta = theta + 1.5707963267948966;
            double fX = Math.cos(fTheta);
            double fZ = Math.sin(fTheta);
            double x = car.m_20185_() + sideX * (double)this.offsetX + fX * (double)this.offsetZ;
            double y = car.m_20186_() + (double)this.offsetY;
            double z = car.m_20189_() + sideZ * (double)this.offsetX + fZ * (double)this.offsetZ;
            return new Vec3(x, y, z);
        }

        public AABB getBounds(VehicleEntity car) {
            Vec3 p = this.getPos(car);
            return new AABB(p.f_82479_ - (double)this.radius, p.f_82480_, p.f_82481_ - (double)this.radius, p.f_82479_ + (double)this.radius, p.f_82480_ + (double)this.offsetY + (double)this.height, p.f_82481_ + (double)this.radius);
        }

        public float getOffsetY() {
            return this.offsetY;
        }

        public float getOffsetZ() {
            return this.offsetZ;
        }

        public InterpValue getInterpValue() {
            return this.interpValue;
        }
    }

    protected static class WheelData {
        public final Vec2 bl;
        public final Vec2 br;
        public final Vec2 fl;
        public final Vec2 fr;
        public final Vector4f carVector;

        public WheelData(double backLeftX, double backLeftZ, double frontRightX, double frontRightZ) {
            this.bl = new Vec2((float)backLeftX, (float)backLeftZ);
            this.br = new Vec2((float)frontRightX, (float)backLeftZ);
            this.fl = new Vec2((float)backLeftX, (float)frontRightZ);
            this.fr = new Vec2((float)frontRightX, (float)frontRightZ);
            this.carVector = new Vector4f((float)backLeftX, (float)backLeftZ, (float)frontRightX, (float)frontRightZ);
        }
    }

    public static enum Speed {
        SLOW(0.5f),
        MEDIUM(1.0f),
        FAST(2.0f);

        public final float modifier;

        private Speed(float modifier) {
            this.modifier = modifier;
        }
    }
}

