/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.misc;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.item.BlueprintPaintingEntity;

public class BlueprintItem
extends Item {
    public static final TagKey<PaintingVariant> BLUEPRINT_VARIANTS_TAG = TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.PAINTING_VARIANTS, (ResourceLocation)new ResourceLocation("jurassicreborn", "blueprint_variants"));
    private static final String NBT_VARIANT = "VariantId";

    public BlueprintItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Direction face = ctx.m_43719_();
        if (!face.m_122434_().m_122479_()) {
            return InteractionResult.PASS;
        }
        Holder<PaintingVariant> variant = this.getStoredVariant(ctx.m_43722_(), ctx.m_43725_());
        if (variant == null) {
            return InteractionResult.PASS;
        }
        Level level = ctx.m_43725_();
        BlueprintPaintingEntity painting = new BlueprintPaintingEntity(level, pos = ctx.m_8083_().m_121945_(face), face, variant);
        if (painting.m_7088_()) {
            if (!level.f_46443_) {
                painting.setBlueprintTexture(BlueprintItem.textureFor(variant));
                level.m_7967_((Entity)painting);
                painting.m_7084_();
                if (!ctx.m_43723_().m_7500_()) {
                    ctx.m_43722_().m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        List list = ForgeRegistries.PAINTING_VARIANTS.tags().getTag(BLUEPRINT_VARIANTS_TAG).stream().toList();
        if (list.isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ResourceLocation curId = this.getStoredId(stack);
        int idx = 0;
        if (curId != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!ForgeRegistries.PAINTING_VARIANTS.getKey((Object)((PaintingVariant)list.get(i))).equals((Object)curId)) continue;
                idx = i;
                break;
            }
        }
        PaintingVariant nextPv = (PaintingVariant)list.get((idx + 1) % list.size());
        stack.m_41784_().m_128359_(NBT_VARIANT, ForgeRegistries.PAINTING_VARIANTS.getKey((Object)nextPv).toString());
        if (level.f_46443_) {
            player.m_5661_((Component)Component.m_237113_((String)("Blueprint set to: " + ForgeRegistries.PAINTING_VARIANTS.getKey((Object)nextPv).m_135815_())), true);
        }
        player.m_6674_(hand);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        ResourceLocation id = this.getStoredId(stack);
        if (id != null) {
            lines.add((Component)Component.m_237113_((String)("Design: " + id.m_135815_())).m_130940_(ChatFormatting.AQUA));
        }
        lines.add((Component)Component.m_237113_((String)"Right-click in the air to change design").m_130940_(ChatFormatting.GRAY));
    }

    private Holder<PaintingVariant> getStoredVariant(ItemStack stack, Level level) {
        PaintingVariant pv;
        ResourceLocation id = this.getStoredId(stack);
        if (id != null && (pv = (PaintingVariant)ForgeRegistries.PAINTING_VARIANTS.getValue(id)) != null) {
            return ForgeRegistries.PAINTING_VARIANTS.getHolder((Object)pv).orElse(null);
        }
        List<Holder<PaintingVariant>> list = this.getVariantList();
        if (list.isEmpty()) {
            return null;
        }
        stack.m_41784_().m_128359_(NBT_VARIANT, ForgeRegistries.PAINTING_VARIANTS.getKey((Object)((PaintingVariant)list.get(0).m_203334_())).toString());
        return list.get(0);
    }

    @Nullable
    private ResourceLocation getStoredId(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(NBT_VARIANT)) {
            return null;
        }
        return new ResourceLocation(stack.m_41783_().m_128461_(NBT_VARIANT));
    }

    private List<Holder<PaintingVariant>> getVariantList() {
        return ForgeRegistries.PAINTING_VARIANTS.tags().getTag(BLUEPRINT_VARIANTS_TAG).stream().map(pv -> ForgeRegistries.PAINTING_VARIANTS.getHolder(pv).orElse(null)).filter(Objects::nonNull).toList();
    }

    private static ResourceLocation textureFor(Holder<PaintingVariant> var) {
        ResourceLocation id = ForgeRegistries.PAINTING_VARIANTS.getKey((Object)((PaintingVariant)var.m_203334_()));
        return new ResourceLocation("jurassicreborn", "textures/painting/" + id.m_135815_() + ".png");
    }
}

