/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.jei.fossilgrinder;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.world.item.ItemStack;
import net.vit.jurassicreborn.common.jei.fossilgrinder.GrinderInput;

public class FossilGrinderRecipeExtension
implements IRecipeCategoryExtension {
    private static final int SLOT_SIZE = 18;
    private final GrinderInput input;
    private final List<Pair<Float, ItemStack>> outputs = new ArrayList<Pair<Float, ItemStack>>();

    public FossilGrinderRecipeExtension(GrinderInput input) {
        this.input = input;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focuses) {
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 3; ++col) {
                builder.addSlot(RecipeIngredientRole.INPUT, 5 + col * 18, 5 + row * 18).addItemStack(this.input.stack);
            }
        }
        this.outputs.clear();
        this.outputs.addAll(this.input.grind.getChancedOutputs(this.input.stack));
        int slotCount = 6;
        for (int slot = 0; slot < slotCount; ++slot) {
            int row = slot / 3;
            int col = slot % 3;
            IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, 90 + col * 18, 5 + row * 18);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = slot; i < this.outputs.size(); i += slotCount) {
                stacks.add((ItemStack)this.outputs.get(i).getSecond());
            }
            if (stacks.isEmpty()) continue;
            slotBuilder.addItemStacks(stacks);
        }
    }
}

