/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class SetOrderPacket {
    private final int entityId;
    private final int orderOrdinal;

    public SetOrderPacket(int entityId, int orderOrdinal) {
        this.entityId = entityId;
        this.orderOrdinal = orderOrdinal;
    }

    public SetOrderPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.orderOrdinal = buf.readInt();
    }

    public static void toBytes(SetOrderPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.entityId);
        buf.writeInt(pkt.orderOrdinal);
    }

    public static void handle(SetOrderPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level world = player.f_19853_;
            Entity e = world.m_6815_(pkt.entityId);
            if (e instanceof DinosaurEntity) {
                DinosaurEntity dinosaur = (DinosaurEntity)e;
                DinosaurEntity.Order[] orders = DinosaurEntity.Order.values();
                if (pkt.orderOrdinal >= 0 && pkt.orderOrdinal < orders.length) {
                    dinosaur.setFieldOrder(orders[pkt.orderOrdinal]);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

