/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class TrackDinosaurPacket {
    private final int dinosaurEntityId;

    public TrackDinosaurPacket(int dinosaurEntityId) {
        this.dinosaurEntityId = dinosaurEntityId;
    }

    public TrackDinosaurPacket(FriendlyByteBuf buf) {
        this.dinosaurEntityId = buf.readInt();
    }

    public static void toBytes(TrackDinosaurPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.dinosaurEntityId);
    }

    public static void handle(TrackDinosaurPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            Level world = player.f_19853_;
            Entity e = world.m_6815_(msg.dinosaurEntityId);
            if (e instanceof DinosaurEntity) {
                DinosaurEntity dino = (DinosaurEntity)e;
                dino.addTracker(player.m_20148_());
            }
        });
        ctx.setPacketHandled(true);
    }
}

