/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.vit.jurassicreborn.common.worldgen.ModConfiguredFeatures;
import net.vit.jurassicreborn.common.worldgen.ModOrePlacement;

public final class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> FLORA_FOSSIL = ModPlacedFeatures.key("placement_flora_fossil");
    public static final ResourceKey<PlacedFeature> FAUNA_FOSSIL = ModPlacedFeatures.key("placement_fauna_fossil");
    public static final ResourceKey<PlacedFeature> AMBER_ORE = ModPlacedFeatures.key("placement_amber_ore");
    public static final ResourceKey<PlacedFeature> ICE_SHARD_ORE = ModPlacedFeatures.key("placement_ice_shard_ore");
    public static final ResourceKey<PlacedFeature> PETRIFIED_LARGE = ModPlacedFeatures.key("placed_large_petrified_tree");
    public static final ResourceKey<PlacedFeature> PETRIFIED_SMALL = ModPlacedFeatures.key("placed_small_petrified_tree");
    public static final ResourceKey<PlacedFeature> NEST_FOSSIL = ModPlacedFeatures.key("placed_nest_fossil");

    private ModPlacedFeatures() {
    }

    public static void bootstrap(BootstapContext<PlacedFeature> ctx) {
        HolderGetter cf = ctx.m_255420_(Registries.f_256911_);
        Holder.Reference flora = cf.m_255043_(ModConfiguredFeatures.FLORA_FOSSIL_ORE);
        Holder.Reference fauna = cf.m_255043_(ModConfiguredFeatures.FAUNA_FOSSIL_ORE);
        Holder.Reference amber = cf.m_255043_(ModConfiguredFeatures.AMBER_ORE);
        Holder.Reference ice = cf.m_255043_(ModConfiguredFeatures.ICE_SHARD_ORE);
        Holder.Reference nest = cf.m_255043_(ModConfiguredFeatures.NEST_FOSSIL);
        Holder.Reference petrL = cf.m_255043_(ModConfiguredFeatures.PETRIFIED_TREE_LARGE);
        Holder.Reference petrS = cf.m_255043_(ModConfiguredFeatures.PETRIFIED_TREE_SMALL);
        ModPlacedFeatures.register(ctx, FLORA_FOSSIL, flora, ModOrePlacement.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModPlacedFeatures.register(ctx, FAUNA_FOSSIL, fauna, ModOrePlacement.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModPlacedFeatures.register(ctx, AMBER_ORE, amber, ModOrePlacement.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModPlacedFeatures.register(ctx, ICE_SHARD_ORE, ice, ModOrePlacement.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModPlacedFeatures.register(ctx, NEST_FOSSIL, nest, ModOrePlacement.chancedOrePlacement((PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)30), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))));
        ModPlacedFeatures.register(ctx, PETRIFIED_LARGE, petrL, ModOrePlacement.chancedOrePlacement((PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ModPlacedFeatures.register(ctx, PETRIFIED_SMALL, petrS, ModOrePlacement.chancedOrePlacement((PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
    }

    private static ResourceKey<PlacedFeature> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("jurassicreborn", name));
    }

    private static void register(BootstapContext<PlacedFeature> ctx, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configured, List<PlacementModifier> modifiers) {
        ctx.m_255272_(key, (Object)new PlacedFeature(configured, List.copyOf(modifiers)));
    }
}

