/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.BitSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class VariantOreFeature
extends Feature<OreConfiguration> {
    public static final Codec<OreConfiguration> CODEC = OreConfiguration.f_67837_;

    public VariantOreFeature() {
        super(CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<OreConfiguration> ctx) {
        RandomSource rand = ctx.m_225041_();
        BlockPos origin = ctx.m_159777_();
        WorldGenLevel level = ctx.m_159774_();
        OreConfiguration original = (OreConfiguration)ctx.m_159778_();
        BlockState firstState = ((OreConfiguration.TargetBlockState)original.f_161005_.get((int)0)).f_161033_;
        Property prop = firstState.m_60734_().m_49965_().m_61081_("variant");
        if (!(prop instanceof IntegerProperty)) {
            throw new IllegalStateException("Missing variant property on " + firstState);
        }
        IntegerProperty variantProp = (IntegerProperty)prop;
        int min = variantProp.m_6908_().stream().min(Integer::compare).orElse(0);
        int max = variantProp.m_6908_().stream().max(Integer::compare).orElse(min);
        ArrayList<OreConfiguration.TargetBlockState> variants = new ArrayList<OreConfiguration.TargetBlockState>();
        for (OreConfiguration.TargetBlockState baseTarget : original.f_161005_) {
            RuleTest test = baseTarget.f_161032_;
            BlockState fossil = baseTarget.f_161033_;
            for (int i = min; i <= max; ++i) {
                variants.add(OreConfiguration.m_161021_((RuleTest)test, (BlockState)((BlockState)fossil.m_61124_((Property)variantProp, (Comparable)Integer.valueOf(i)))));
            }
        }
        OreConfiguration config = new OreConfiguration(variants, original.f_67839_, original.f_161006_);
        float angle = rand.m_188501_() * (float)Math.PI;
        double dx1 = (float)origin.m_123341_() + Mth.m_14031_((float)angle) * (float)config.f_67839_ / 8.0f;
        double dx2 = (float)origin.m_123341_() - Mth.m_14031_((float)angle) * (float)config.f_67839_ / 8.0f;
        double dz1 = (float)origin.m_123343_() + Mth.m_14089_((float)angle) * (float)config.f_67839_ / 8.0f;
        double dz2 = (float)origin.m_123343_() - Mth.m_14089_((float)angle) * (float)config.f_67839_ / 8.0f;
        double dy1 = origin.m_123342_() + rand.m_188503_(3) - 1;
        double dy2 = origin.m_123342_() + rand.m_188503_(3) - 1;
        int centerY = origin.m_123342_();
        int spreadY = 2;
        int minY = Math.max(centerY - spreadY, level.m_141937_());
        int maxY = Math.min(centerY + spreadY, level.m_151558_());
        int minX = origin.m_123341_() - Mth.m_14167_((float)((float)config.f_67839_ / 8.0f)) - 1;
        int minZ = origin.m_123343_() - Mth.m_14167_((float)((float)config.f_67839_ / 8.0f)) - 1;
        int width = 2 * (Mth.m_14167_((float)((float)config.f_67839_ / 8.0f)) + 1);
        return this.doPlace(level, rand, config, dx1, dx2, dz1, dz2, dy1, dy2, minX, minY, maxY, minZ, width);
    }

    private boolean doPlace(WorldGenLevel level, RandomSource rand, OreConfiguration config, double dx1, double dx2, double dz1, double dz2, double dy1, double dy2, int minX, int minY, int maxY, int minZ, int width) {
        double r;
        int i;
        int placed = 0;
        int height = maxY - minY + 1;
        if (width <= 0 || height <= 0) {
            return false;
        }
        BitSet bitset = new BitSet(width * height * width);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int size = config.f_67839_;
        double[] coords = new double[size * 4];
        for (i = 0; i < size; ++i) {
            float f = (float)i / (float)size;
            coords[i * 4 + 0] = Mth.m_14139_((double)f, (double)dx1, (double)dx2);
            coords[i * 4 + 1] = Mth.m_14139_((double)f, (double)dy1, (double)dy2);
            coords[i * 4 + 2] = Mth.m_14139_((double)f, (double)dz1, (double)dz2);
            r = rand.m_188500_() * (double)size / 16.0;
            coords[i * 4 + 3] = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * r + 1.0) / 2.0;
        }
        for (i = 0; i < size - 1; ++i) {
            if (!(coords[i * 4 + 3] > 0.0)) continue;
            for (int j = i + 1; j < size; ++j) {
                double dz;
                double dy;
                double dx;
                double dr;
                if (!(coords[j * 4 + 3] > 0.0) || !((dr = coords[i * 4 + 3] - coords[j * 4 + 3]) * dr > (dx = coords[i * 4] - coords[j * 4]) * dx + (dy = coords[i * 4 + 1] - coords[j * 4 + 1]) * dy + (dz = coords[i * 4 + 2] - coords[j * 4 + 2]) * dz)) continue;
                if (dr > 0.0) {
                    coords[j * 4 + 3] = -1.0;
                    continue;
                }
                coords[i * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess access = new BulkSectionAccess((LevelAccessor)level);){
            for (int i2 = 0; i2 < size; ++i2) {
                r = coords[i2 * 4 + 3];
                if (r < 0.0) continue;
                double cx = coords[i2 * 4];
                double cy = coords[i2 * 4 + 1];
                double cz = coords[i2 * 4 + 2];
                int x0 = Math.max(Mth.m_14107_((double)(cx - r)), minX);
                int y0 = Math.max(Mth.m_14107_((double)(cy - r)), minY);
                int z0 = Math.max(Mth.m_14107_((double)(cz - r)), minZ);
                int x1 = Math.min(Mth.m_14107_((double)(cx + r)), x0 + width);
                int y1 = Math.min(Mth.m_14107_((double)(cy + r)), maxY);
                int z1 = Math.min(Mth.m_14107_((double)(cz + r)), z0 + width);
                for (int x = x0; x <= x1; ++x) {
                    double dx = ((double)x + 0.5 - cx) / r;
                    if (!(dx * dx < 1.0)) continue;
                    for (int y = y0; y <= y1; ++y) {
                        double dy;
                        if (y < minY || y > maxY || !(dx * dx + (dy = ((double)y + 0.5 - cy) / r) * dy < 1.0)) continue;
                        block11: for (int z = z0; z <= z1; ++z) {
                            LevelChunkSection sect;
                            int idx;
                            double dz = ((double)z + 0.5 - cz) / r;
                            if (!(dx * dx + dy * dy + dz * dz < 1.0) || bitset.get(idx = x - minX + (y - minY) * width + (z - minZ) * width * height)) continue;
                            bitset.set(idx);
                            pos.m_122178_(x, y, z);
                            if (level.m_151562_(y) || (sect = access.m_156104_((BlockPos)pos)) == null) continue;
                            BlockState curr = sect.m_62982_(SectionPos.m_123207_((int)x), SectionPos.m_123207_((int)y), SectionPos.m_123207_((int)z));
                            ArrayList<OreConfiguration.TargetBlockState> list = new ArrayList<OreConfiguration.TargetBlockState>(config.f_161005_);
                            for (int j = list.size() - 1; j > 0; --j) {
                                int k = rand.m_188503_(j + 1);
                                OreConfiguration.TargetBlockState tmp = (OreConfiguration.TargetBlockState)list.get(j);
                                list.set(j, (OreConfiguration.TargetBlockState)list.get(k));
                                list.set(k, tmp);
                            }
                            for (OreConfiguration.TargetBlockState target : list) {
                                if (!OreFeature.m_225186_((BlockState)curr, arg_0 -> ((BulkSectionAccess)access).m_156110_(arg_0), (RandomSource)rand, (OreConfiguration)config, (OreConfiguration.TargetBlockState)target, (BlockPos.MutableBlockPos)pos)) continue;
                                sect.m_62991_(SectionPos.m_123207_((int)x), SectionPos.m_123207_((int)y), SectionPos.m_123207_((int)z), target.f_161033_, false);
                                ++placed;
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        return placed > 0;
    }
}

