/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.worldgen.structure.StructureGenerator;

public class VisitorCentreGenerator
extends StructureGenerator {
    private static final ResourceLocation STRUCTURE = JurassicReborn.resource("visitor_centre");
    private static final Map<String, ResourceLocation> LOOT_TABLES = new HashMap<String, ResourceLocation>();

    public VisitorCentreGenerator(RandomSource rand) {
        super(rand, 85, 35, 105);
    }

    @Override
    protected void generateStructure(ServerLevel level, RandomSource random, BlockPos position) {
        StructureTemplateManager manager = level.m_215082_();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.m_74379_(this.rotation);
        settings.m_74377_(this.mirror);
        settings.m_230324_(random);
        StructureTemplate template = manager.m_230359_(STRUCTURE);
        template.m_230328_((ServerLevelAccessor)level, position, position, settings, random, 4);
        List dataBlocks = template.m_74603_(position, settings, Blocks.f_50677_);
        for (StructureTemplate.StructureBlockInfo info : dataBlocks) {
            String type = info.f_74677_.m_128461_("metadata");
            ResourceLocation loot = LOOT_TABLES.get(type);
            if (loot == null) continue;
            level.m_7731_(info.f_74675_, Blocks.f_50016_.m_49966_(), 3);
            BlockEntity tile = level.m_7702_(info.f_74675_.m_7495_());
            if (!(tile instanceof ChestBlockEntity)) continue;
            ChestBlockEntity chest = (ChestBlockEntity)tile;
            chest.m_59626_(loot, random.m_188505_());
        }
    }

    @Override
    public BlockPos getLevelPosition() {
        return new BlockPos(38, 3, 1);
    }

    static {
        LOOT_TABLES.put("GroundStorage", new ResourceLocation("jurassicreborn", "structure/visitor_centre/ground_storage"));
        LOOT_TABLES.put("ControlRoom", new ResourceLocation("jurassicreborn", "structure/visitor_centre/control_room"));
        LOOT_TABLES.put("Laboratory", new ResourceLocation("jurassicreborn", "structure/visitor_centre/laboratory"));
        LOOT_TABLES.put("Cryonics", new ResourceLocation("jurassicreborn", "structure/visitor_centre/cryonics"));
        LOOT_TABLES.put("Infirmary", new ResourceLocation("jurassicreborn", "structure/visitor_centre/infirmary"));
        LOOT_TABLES.put("Garage", new ResourceLocation("jurassicreborn", "structure/visitor_centre/garage"));
        LOOT_TABLES.put("StaffDorms", new ResourceLocation("jurassicreborn", "structure/visitor_centre/staff_dorms"));
        LOOT_TABLES.put("Kitchen", new ResourceLocation("jurassicreborn", "structure/visitor_centre/kitchen"));
        LOOT_TABLES.put("DormTower", new ResourceLocation("jurassicreborn", "structure/visitor_centre/dorm_tower"));
        LOOT_TABLES.put("DiningHall", new ResourceLocation("jurassicreborn", "structure/visitor_centre/dining_hall"));
    }
}

