/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.vit.jurassicreborn.client.JurassicClient;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.screens.paleopad.GuiAppRegistry;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.CommonRegistries;
import net.vit.jurassicreborn.common.RebornConfig;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.ModMenuTypes;
import net.vit.jurassicreborn.common.blocks.entities.cultivator.CultivatorBlockEntity;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.command.DoDinoBreedingCommand;
import net.vit.jurassicreborn.common.command.ForceAnimationCommand;
import net.vit.jurassicreborn.common.command.MetabolismCommand;
import net.vit.jurassicreborn.common.command.SpawnStructureCommand;
import net.vit.jurassicreborn.common.datagen.JRDatagen;
import net.vit.jurassicreborn.common.entities.BlueprintPaintings;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.EventListener;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.entities.MuralPaintings;
import net.vit.jurassicreborn.common.entities.PaddockSignPaintings;
import net.vit.jurassicreborn.common.entities.animal.CrabEntity;
import net.vit.jurassicreborn.common.entities.animal.GoatEntity;
import net.vit.jurassicreborn.common.entities.animal.SharkEntity;
import net.vit.jurassicreborn.common.items.Food.FoodHelper;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.paleopad.AppHandler;
import net.vit.jurassicreborn.common.plants.PlantHandler;
import net.vit.jurassicreborn.common.recipes.cleaner.CleaningRecipe;
import net.vit.jurassicreborn.common.util.GameRuleHandler;
import net.vit.jurassicreborn.common.util.particles.ModParticles;
import net.vit.jurassicreborn.common.worldgen.ConfiguredFeatureRegistries;
import net.vit.jurassicreborn.common.worldgen.ModFeatures;
import net.vit.jurassicreborn.common.worldgen.loot.ModLootModifiers;
import net.vit.jurassicreborn.common.worldgen.villager.ModVillagers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jurassicreborn")
public class JurassicReborn {
    public static final String MODID = "jurassicreborn";
    private static final Logger LOGGER = LogManager.getLogger();
    public static ArrayList<String> erroredIdentifiers = new ArrayList();
    private static final String things_to_bring_up = "1: Half-slab ActionFigrures: the challenges of hitboxes larger than one block pt. 1\n2: Incubator: The challenges of hitboxes larger than one block pt. 2\n    -> collission is screwed, can I make it a multipart block like the cultivator\n3:\n\n\n";

    public static ResourceLocation resource(String resource) {
        return new ResourceLocation(MODID, resource);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public JurassicReborn() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (FMLEnvironment.dist.isClient()) {
            JurassicClient.init(modEventBus);
        }
        SoundHandler.registrer.register(modEventBus);
        WoodBlocks.register();
        ModParticles.init(modEventBus);
        ModBlocks.register(modEventBus);
        DinosaurHandler.doDinosInit();
        PlantHandler.init();
        ModItems.register(modEventBus);
        ModVillagers.register(modEventBus);
        ModEntities.init(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        CommonRegistries.BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        CommonRegistries.init();
        modEventBus.addListener(EventListener::finalizeSetup);
        modEventBus.addListener(EventListener::registerAttributes);
        modEventBus.addListener(this::registerRecipeSerializers);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(JRDatagen::gather);
        MinecraftForge.EVENT_BUS.addListener(this::serverTickEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onLevelLoadEvent);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        modEventBus.addListener(this::onLoadComplete);
        AppHandler.INSTANCE.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> GuiAppRegistry::register);
        MuralPaintings.register(modEventBus);
        BlueprintPaintings.register(modEventBus);
        PaddockSignPaintings.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLootModifiers.register(modEventBus);
        Network.init();
        GameRuleHandler.init();
        System.out.println(JurassicReborn.toString((Object[])EntityAnimation.values()));
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        FoodHelper.init();
    }

    public void setup(FMLCommonSetupEvent event) {
        ConfiguredFeatureRegistries.init();
        CultivatorBlockEntity.FoodNutrients.register();
        event.enqueueWork(() -> {
            if (RebornConfig.spawnCrabs) {
                SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.CRAB.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrabEntity::checkCrabSpawnRules);
            }
            if (RebornConfig.spawnSharks) {
                SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.SHARK.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SharkEntity::checkSharkSpawnRules);
            }
            if (RebornConfig.spawnGoats) {
                SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.GOAT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GoatEntity::checkGoatSpawnRules);
            }
        });
    }

    public void onLevelLoadEvent(LevelEvent.Load evt) {
    }

    public void registerCommands(RegisterCommandsEvent event) {
        MetabolismCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DoDinoBreedingCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ForceAnimationCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SpawnStructureCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public void registerRecipeSerializers(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper2 -> helper2.register(JurassicReborn.resource("cleaning_recipe_serializer"), (Object)CleaningRecipe.INSTANCE));
        event.register(ForgeRegistries.Keys.RECIPE_TYPES, helper2 -> helper2.register(JurassicReborn.resource("cleaning_recipe_type"), CleaningRecipe.CLEANING));
    }

    public static Boolean never(BlockState p_50779_, BlockGetter p_50780_, BlockPos p_50781_, EntityType<?> p_50782_) {
        return false;
    }

    public static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    public static void debugHook() {
        System.out.println("Debugging!");
    }

    public static void checkCubeId(String id) {
    }

    public void serverTickEvent(TickEvent.ServerTickEvent evt) {
        Network.removeRemovedEntities();
    }

    public static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append("\"");
            b.append(a[i]);
            b.append("\"");
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

