/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.basic.BasicEntityModel;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.entity.CrabAnimator;
import net.vit.jurassicreborn.common.entities.animal.CrabEntity;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;

@OnlyIn(value=Dist.CLIENT)
public class CrabEntityRenderer
extends LivingEntityRenderer<CrabEntity, BasicEntityModel<CrabEntity>> {
    private static final AnimatableModel CRAB_MODEL;
    private static final ResourceLocation CRAB_TEXTURE;
    private static final ResourceLocation ALT_TEXTURE;

    public CrabEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)CRAB_MODEL, 0.2f);
    }

    public void render(CrabEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(CrabEntity entity, PoseStack poseStack, float partialTickTime) {
        float base;
        float f = base = entity.m_6162_() ? 0.3f : 0.5f;
        if (entity.getCrabType() == CrabEntity.Type.ALTERNATIVE && !entity.m_6162_()) {
            base = 0.55f;
        }
        poseStack.m_85841_(base, base, base);
        super.m_7546_((LivingEntity)entity, poseStack, partialTickTime);
    }

    public ResourceLocation getTextureLocation(CrabEntity entity) {
        return entity.getCrabType() == CrabEntity.Type.ALTERNATIVE ? ALT_TEXTURE : CRAB_TEXTURE;
    }

    static {
        CRAB_TEXTURE = new ResourceLocation("jurassicreborn", "textures/entities/crab/crab.png");
        ALT_TEXTURE = new ResourceLocation("jurassicreborn", "textures/entities/crab/male_crab.png");
        TabulaModelContainer crab = null;
        try {
            crab = TabulaModelHelper.loadTabulaModel("assets/jurassicreborn/models/entities/crab/adult/crab");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CRAB_MODEL = new AnimatableModel(crab, new CrabAnimator());
    }
}

