/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.basic.BasicEntityModel;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.entity.GoatAnimator;
import net.vit.jurassicreborn.common.entities.animal.GoatEntity;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;

@OnlyIn(value=Dist.CLIENT)
public class GoatEntityRenderer
extends LivingEntityRenderer<GoatEntity, BasicEntityModel<GoatEntity>> {
    private static final AnimatableModel BILLY_MODEL;
    private static final AnimatableModel NANNY_MODEL;
    private static final AnimatableModel KID_MODEL;
    private static final ResourceLocation BILLY_JW;
    private static final ResourceLocation BILLY_JP;
    private static final ResourceLocation BILLY_JPOG;
    private static final ResourceLocation NANNY_JW;
    private static final ResourceLocation NANNY_JP;
    private static final ResourceLocation NANNY_JPOG;
    private static final ResourceLocation KID_JW;
    private static final ResourceLocation KID_JP;
    private static final ResourceLocation KID_JPOG;

    public GoatEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)NANNY_MODEL, 0.4f);
    }

    private AnimatableModel modelFor(GoatEntity entity) {
        GoatEntity.Type type = entity.getGoatType();
        return switch (type) {
            case GoatEntity.Type.BILLY -> BILLY_MODEL;
            case GoatEntity.Type.KID -> KID_MODEL;
            default -> NANNY_MODEL;
        };
    }

    private ResourceLocation textureFor(GoatEntity entity) {
        GoatEntity.Variant variant = entity.getVariant();
        return switch (entity.getGoatType()) {
            default -> throw new IncompatibleClassChangeError();
            case GoatEntity.Type.BILLY -> {
                switch (variant) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case JURASSIC_WORLD: {
                        yield BILLY_JW;
                    }
                    case JURASSIC_PARK: {
                        yield BILLY_JP;
                    }
                    case JPOG: 
                }
                yield BILLY_JPOG;
            }
            case GoatEntity.Type.KID -> {
                switch (variant) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case JURASSIC_WORLD: {
                        yield KID_JW;
                    }
                    case JURASSIC_PARK: {
                        yield KID_JP;
                    }
                    case JPOG: 
                }
                yield KID_JPOG;
            }
            case GoatEntity.Type.NANNY -> {
                switch (variant) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case JURASSIC_WORLD: {
                        yield NANNY_JW;
                    }
                    case JURASSIC_PARK: {
                        yield NANNY_JP;
                    }
                    case JPOG: 
                }
                yield NANNY_JPOG;
            }
        };
    }

    protected void scale(GoatEntity entity, PoseStack poseStack, float partialTickTime) {
        float scale = switch (entity.getGoatType()) {
            case GoatEntity.Type.BILLY -> 0.5f;
            case GoatEntity.Type.KID -> 0.3f;
            default -> 0.45f;
        };
        poseStack.m_85841_(scale, scale, scale);
        super.m_7546_((LivingEntity)entity, poseStack, partialTickTime);
    }

    public void render(GoatEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        AnimatableModel model = this.modelFor(entity);
        if (this.f_115290_ != model) {
            this.f_115290_ = model;
        }
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(GoatEntity entity) {
        return this.textureFor(entity);
    }

    static {
        BILLY_JW = new ResourceLocation("jurassicreborn", "textures/entities/goat/billy_jurassic_world.png");
        BILLY_JP = new ResourceLocation("jurassicreborn", "textures/entities/goat/billy_jurassic_park.png");
        BILLY_JPOG = new ResourceLocation("jurassicreborn", "textures/entities/goat/billy_jpog.png");
        NANNY_JW = new ResourceLocation("jurassicreborn", "textures/entities/goat/nanny_jurassic_world.png");
        NANNY_JP = new ResourceLocation("jurassicreborn", "textures/entities/goat/nanny_jurassic_park.png");
        NANNY_JPOG = new ResourceLocation("jurassicreborn", "textures/entities/goat/nanny_jpog.png");
        KID_JW = new ResourceLocation("jurassicreborn", "textures/entities/goat/kid_jurassic_world.png");
        KID_JP = new ResourceLocation("jurassicreborn", "textures/entities/goat/kid_jurassic_park.png");
        KID_JPOG = new ResourceLocation("jurassicreborn", "textures/entities/goat/kid_jpog.png");
        TabulaModelContainer billy = null;
        TabulaModelContainer nanny = null;
        TabulaModelContainer kid = null;
        try {
            billy = TabulaModelHelper.loadTabulaModel("assets/jurassicreborn/models/entities/goat_billy/adult/goat_billy");
            nanny = TabulaModelHelper.loadTabulaModel("assets/jurassicreborn/models/entities/goat_nanny/adult/goat_nanny");
            kid = TabulaModelHelper.loadTabulaModel("assets/jurassicreborn/models/entities/goat_kid/adult/goat_kid");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BILLY_MODEL = new AnimatableModel(billy, new GoatAnimator());
        NANNY_MODEL = new AnimatableModel(nanny, new GoatAnimator());
        KID_MODEL = new AnimatableModel(kid, new GoatAnimator());
    }
}

