/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.JabelarAnimationHandler;
import net.vit.jurassicreborn.common.entities.EntityUtils.Animatable;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityAnimator<ENTITY extends LivingEntity>
implements ITabulaModelAnimator<ENTITY> {
    protected final EnumMap<GrowthStage, Map<ENTITY, JabelarAnimationHandler<ENTITY>>> animationHandlers = new EnumMap(GrowthStage.class);

    private JabelarAnimationHandler<ENTITY> getAnimationHelper(ENTITY entity, AnimatableModel model, boolean useInertialTweens) {
        GrowthStage stage = ((Animatable)entity).getGrowthStage();
        Map<ENTITY, JabelarAnimationHandler<ENTITY>> map = this.animationHandlers.get((Object)stage);
        if (map == null) {
            map = new WeakHashMap<ENTITY, JabelarAnimationHandler<ENTITY>>();
            this.animationHandlers.put(stage, map);
        }
        return map.computeIfAbsent(entity, e -> ((Animatable)e).getPoseHandler().createAnimationHandler((LivingEntity)e, model, stage, useInertialTweens));
    }

    public final void setRotationAngles(TabulaModel model, ENTITY entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        model.resetToDefaultPose();
        this.getAnimationHelper(entity, (AnimatableModel)model, ((Animatable)entity).shouldUseInertia()).performAnimations(entity, limbSwing, limbSwingAmount, ticks);
        int i = 0;
        while (true) {
            AdvancedModelBox cube;
            if ((cube = model.getCube("neck" + i++)) == null) {
                cube = model.getCube("throat" + i++);
            }
            if (cube == null) break;
            float j = 1.0f - (float)i * 1.0E-5f;
            cube.scaleX *= j;
            cube.scaleY *= j;
            cube.scaleZ *= j;
            ++i;
        }
        this.performAnimations((AnimatableModel)model, entity, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, scale);
    }

    protected void performAnimations(AnimatableModel model, ENTITY entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
    }
}

