/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.Map;
import net.vit.jurassicreborn.client.render.entity.animation.AnimationPass;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.render.entity.animation.PosedCuboid;
import net.vit.jurassicreborn.common.entities.EntityUtils.Animatable;

public class MovementAnimationPass
extends AnimationPass {
    public MovementAnimationPass(Map<Animation, float[][]> poseSequences, PosedCuboid[][] poses, boolean useInertialTweens) {
        super(poseSequences, poses, useInertialTweens);
    }

    @Override
    protected boolean isEntityAnimationDependent() {
        return false;
    }

    @Override
    protected float getAnimationSpeed(Animatable entity) {
        return this.isMoving(entity) ? this.getAnimationDegree(entity) : 3.0f;
    }

    @Override
    protected float getAnimationDegree(Animatable entity) {
        float degree;
        if (this.animation == EntityAnimation.WALKING.get() || this.animation == EntityAnimation.RUNNING.get() || this.animation == EntityAnimation.SWIMMING.get() || this.animation == EntityAnimation.CLIMBING.get()) {
            degree = entity.inWater() || entity.inLava() ? this.limbSwingAmount * 4.0f : this.limbSwingAmount;
        } else {
            return super.getAnimationDegree(entity);
        }
        return Math.max(this.isMoving(entity) ? 0.5f : 0.0f, Math.min(1.0f, degree));
    }

    @Override
    protected Animation getRequestedAnimation(Animatable entity) {
        if (entity.isCarcass()) {
            return EntityAnimation.IDLE.get();
        }
        if (entity.isClimbing()) {
            return EntityAnimation.CLIMBING.get();
        }
        if (this.isMoving(entity)) {
            if (entity.inWater() || entity.inLava()) {
                return this.animations.containsKey(EntityAnimation.SWIMMING.get()) ? EntityAnimation.SWIMMING.get() : EntityAnimation.WALKING.get();
            }
            if (entity.isRunning()) {
                return EntityAnimation.RUNNING.get();
            }
            return EntityAnimation.WALKING.get();
        }
        return EntityAnimation.IDLE.get();
    }

    private boolean isMoving(Animatable entity) {
        return entity.isMoving();
    }

    @Override
    public boolean isLooping() {
        return true;
    }
}

