/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.vehicle;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import net.vit.jurassicreborn.common.entities.vehicle.HelicopterEntity;

public class HelicopterAnimator
implements ITabulaModelAnimator<HelicopterEntity> {
    public void setRotationAngles(TabulaModel model, HelicopterEntity entity, float f, float f1, float rotation, float rotationYaw, float rotationPitch, float partialTicks) {
        AdvancedModelBox rotor = model.getCube("rotorbase_rotatehere");
        AdvancedModelBox tailrotor = model.getCube("tailrotor_rotatehere");
        rotor.rotateAngleY = (float)entity.rotAmount;
        tailrotor.rotateAngleX = (float)entity.rotAmount;
        AdvancedModelBox ctrl1 = model.getCube("controlstick1");
        AdvancedModelBox ctrl2 = model.getCube("controlstick2");
        AdvancedModelBox gearL1 = model.getCube("gearL1");
        AdvancedModelBox gearL2 = model.getCube("gearL2");
        AdvancedModelBox gearR1 = model.getCube("gearR1");
        AdvancedModelBox gearR2 = model.getCube("gearR2");
        AdvancedModelBox gearFront = model.getCube("gearFront1");
        AdvancedModelBox exhaustL = model.getCube("body79");
        AdvancedModelBox exhaustR = model.getCube("body80");
        if (entity.isFlying) {
            gearL1.offsetY = entity.gearLift;
            gearL2.offsetY = entity.gearLift;
            gearR1.offsetY = entity.gearLift;
            gearR2.offsetY = entity.gearLift;
            gearFront.offsetY = entity.gearLift;
        }
        ctrl1.rotateAngleX = (float)Math.toRadians(entity.interpRotationPitch.getValueForRendering(partialTicks) * -1.0);
        ctrl1.rotateAngleZ = (float)Math.toRadians(entity.interpRotationRoll.getValueForRendering(partialTicks) * 1.0);
        float angleX = -15.0f + entity.pitch / 25.0f * 15.0f;
        if (entity.pitch > 25.0f) {
            angleX = 0.0f;
        } else if (entity.pitch < -25.0f) {
            angleX = -30.0f;
        }
        float angleZ = entity.roll / 20.0f * 15.0f;
        if (entity.roll > 20.0f) {
            angleZ = 15.0f;
        } else if (entity.roll < -20.0f) {
            angleZ = -15.0f;
        }
        ctrl1.rotateAngleX = (float)Math.toRadians(angleX);
        ctrl1.rotateAngleZ = (float)Math.toRadians(angleZ);
    }
}

