/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.vit.jurassicreborn.JurassicReborn;
import org.jetbrains.annotations.Nullable;

public class ClearGlassBlock
extends GlassBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ClearGlassBlock(BlockBehaviour.Properties props) {
        super(props.m_60955_().m_60922_(JurassicReborn::never).m_60924_(JurassicReborn::never).m_60960_(JurassicReborn::never).m_60971_(JurassicReborn::never));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        FluidState fluidState = ctx.m_43725_().m_6425_(pos);
        BlockState base = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return this.computeConnections(base, (BlockGetter)world, pos);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockState updated;
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_ && !(updated = this.computeConnections(state, (BlockGetter)level, pos)).equals(state)) {
            level.m_7731_(pos, updated, 3);
        }
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        BlockState updated = super.m_7417_(state, dir, neighbor, world, pos, neighborPos);
        return this.computeConnections(updated, (BlockGetter)world, pos);
    }

    private BlockState computeConnections(BlockState baseState, BlockGetter world, BlockPos pos) {
        for (Direction d : Direction.values()) {
            BooleanProperty prop = ClearGlassBlock.getStateForDirection(d);
            boolean connect = world.m_8055_(pos.m_121945_(d)).m_60734_() instanceof ClearGlassBlock;
            baseState = (BlockState)baseState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(connect));
        }
        return baseState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    public static BooleanProperty getStateForDirection(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.SOUTH -> SOUTH;
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

