/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.ancientplants;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.common.blocks.ModBlocks;

public class AncientPlantBlock
extends BushBlock {
    private static final int DENSITY_PER_AREA = 4;
    private static final int SPREAD_RADIUS = 6;

    public AncientPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public AncientPlantBlock() {
        super(ModBlocks.defaultPlant());
    }

    protected boolean isNearWater(ServerLevel world, BlockPos pos) {
        for (BlockPos neighbourPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-8, -3, -8), (BlockPos)pos.m_7918_(8, 3, 8))) {
            Block neighbourBlock = world.m_8055_(neighbourPos).m_60734_();
            if (neighbourBlock != Blocks.f_49990_) continue;
            return pos.m_123331_((Vec3i)neighbourPos) < 9.0;
        }
        return false;
    }

    protected void spread(ServerLevel world, BlockPos pos) {
        world.m_46597_(pos, this.m_49966_());
    }

    protected BlockPos findGround(ServerLevel world, BlockPos start) {
        BlockPos pos = start;
        for (int i = 0; i < 8; ++i) {
            BlockState here;
            BlockState below = world.m_8055_(pos.m_7495_());
            if (this.canPlace(below, here = world.m_8055_(pos), pos.m_7495_(), (LevelReader)world)) {
                return pos.m_7495_();
            }
            pos = pos.m_7494_();
        }
        return null;
    }

    protected boolean canPlace(BlockState down, BlockState here, BlockPos below, LevelReader world) {
        return down.m_60783_((BlockGetter)world, below, Direction.UP) && here.m_60795_();
    }
}

