/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.bugcrate;

import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.bugcrate.BugCrateMenu;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.items.Food.FoodHelper;
import net.vit.jurassicreborn.common.util.BreedableBug;

public class BugCrateBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    public static final int PLANT_SLOT_START = 0;
    public static final int PLANT_SLOT_END = 2;
    public static final int INSECT_SLOT_START = 3;
    public static final int INSECT_SLOT_END = 5;
    public static final int OUTPUT_SLOT_START = 6;
    public static final int OUTPUT_SLOT_END = 8;
    public static final int SIZE = 9;
    private static final int BREED_TICKS = 200;
    private int breedProgress = 0;
    private int lastBugTypeSlot = -1;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int idx) {
            if (idx == 0) {
                return BugCrateBlockEntity.this.breedProgress;
            }
            if (idx == 1) {
                return 200;
            }
            return 0;
        }

        public void m_8050_(int idx, int value) {
            if (idx == 0) {
                BugCrateBlockEntity.this.breedProgress = value;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public BugCrateBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.BUG_CRATE.get(), pos, state);
    }

    public BugCrateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected Component m_6820_() {
        return Component.m_237113_((String)"Bug Crate");
    }

    public int m_6643_() {
        return 9;
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        return new BugCrateMenu(id, playerInv, (Container)this, this.dataAccess);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        if (slot >= 0 && slot <= 2) {
            return FoodHelper.isFoodType(stack.m_41720_(), FoodType.PLANT);
        }
        if (slot >= 3 && slot <= 5) {
            return BreedableBug.isBug(stack);
        }
        return false;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BugCrateBlockEntity entity) {
        if (entity.canBreedBug()) {
            ++entity.breedProgress;
            if (entity.breedProgress >= 200) {
                entity.tryBreedBug();
                entity.breedProgress = 0;
            }
        } else {
            entity.breedProgress = 0;
        }
    }

    private boolean canBreedBug() {
        int i;
        boolean hasPlant = false;
        for (i = 0; i <= 2; ++i) {
            if (this.m_8020_(i).m_41619_() || !FoodHelper.isFoodType(this.m_8020_(i).m_41720_(), FoodType.PLANT)) continue;
            hasPlant = true;
            break;
        }
        for (i = 3; i <= 5; ++i) {
            ItemStack bug = this.m_8020_(i);
            if (bug.m_41619_() || !BreedableBug.isBug(bug) || !hasPlant || this.getFreeOutputSlot() == -1) continue;
            this.lastBugTypeSlot = i;
            return true;
        }
        return false;
    }

    private void tryBreedBug() {
        if (this.lastBugTypeSlot == -1) {
            return;
        }
        ItemStack bugInSlot = this.m_8020_(this.lastBugTypeSlot);
        if (bugInSlot.m_41619_() || !BreedableBug.isBug(bugInSlot)) {
            return;
        }
        int plantSlot = this.getFirstPlantSlot();
        if (plantSlot == -1) {
            return;
        }
        Item target = bugInSlot.m_41720_();
        int stackSlot = -1;
        for (int i = 6; i <= 8; ++i) {
            ItemStack existing = this.m_8020_(i);
            if (existing.m_41619_() || existing.m_41720_() != target || !ItemStack.m_41658_((ItemStack)existing, (ItemStack)bugInSlot)) continue;
            stackSlot = i;
            break;
        }
        this.m_7407_(plantSlot, 1);
        if (stackSlot != -1) {
            this.m_8020_(stackSlot).m_41769_(1);
            return;
        }
        int emptySlot = this.getFreeOutputSlot();
        if (emptySlot != -1) {
            ItemStack newBug = new ItemStack((ItemLike)target, 1);
            this.m_6836_(emptySlot, newBug);
        } else if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            double x = (double)this.f_58858_.m_123341_() + 0.5;
            double y = (double)this.f_58858_.m_123342_() + 1.1;
            double z = (double)this.f_58858_.m_123343_() + 0.5;
            ItemStack newBug = new ItemStack((ItemLike)target, 1);
            ItemEntity drop = new ItemEntity(this.f_58857_, x, y, z, newBug);
            this.f_58857_.m_7967_((Entity)drop);
        }
    }

    public int[] m_7071_(Direction direction) {
        return IntStream.range(0, 9).toArray();
    }

    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        return index >= 0 && index <= 5;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index >= 6 && index <= 8;
    }

    private int getFirstPlantSlot() {
        for (int i = 0; i <= 2; ++i) {
            if (this.m_8020_(i).m_41619_() || !FoodHelper.isFoodType(this.m_8020_(i).m_41720_(), FoodType.PLANT)) continue;
            return i;
        }
        return -1;
    }

    private int getFreeOutputSlot() {
        for (int i = 6; i <= 8; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }
}

