/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.fence;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceBaseBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFencePoleBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceWireBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceWireBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.fence.FenceType;
import org.jetbrains.annotations.Nullable;

public class ElectricFencePoleBlock
extends BaseEntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private static final VoxelShape POST_SHAPE = Block.m_49796_((double)5.48, (double)0.0, (double)5.48, (double)10.52, (double)16.0, (double)10.52);
    private final FenceType type;

    public ElectricFencePoleBlock(FenceType type, BlockBehaviour.Properties props) {
        super(props.m_60955_().m_60978_(3.0f));
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return POST_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return POST_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ElectricFencePoleBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{ACTIVE, NORTH, SOUTH, EAST, WEST});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect((LevelAccessor)level, pos.m_122012_(), Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect((LevelAccessor)level, pos.m_122019_(), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect((LevelAccessor)level, pos.m_122029_(), Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect((LevelAccessor)level, pos.m_122024_(), Direction.WEST)))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(this.hasPoweredBase((LevelAccessor)level, pos)));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbour, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        if (dir == Direction.NORTH) {
            state = (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(level, neighbourPos, dir)));
        } else if (dir == Direction.SOUTH) {
            state = (BlockState)state.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(level, neighbourPos, dir)));
        } else if (dir == Direction.EAST) {
            state = (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(level, neighbourPos, dir)));
        } else if (dir == Direction.WEST) {
            state = (BlockState)state.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(level, neighbourPos, dir)));
        }
        if (!level.m_5776_() && level instanceof Level) {
            Level lvl = (Level)level;
            state = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(this.hasPoweredBase((LevelAccessor)lvl, pos)));
        }
        return state;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        if (!level.f_46443_) {
            this.updateConnectedWires(level, pos);
            boolean powered = this.hasPoweredBase((LevelAccessor)level, pos);
            if (powered != (Boolean)state.m_61143_((Property)ACTIVE)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(powered)), 2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canConnect(LevelAccessor world, BlockPos pos, Direction dir) {
        BlockState down;
        Block block;
        ElectricFenceWireBlock wire;
        BlockState st = world.m_8055_(pos);
        Block blk = st.m_60734_();
        if (blk instanceof ElectricFenceWireBlock && (wire = (ElectricFenceWireBlock)blk).getType() == this.type) {
            return true;
        }
        if (blk instanceof ElectricFencePoleBlock) {
            ElectricFencePoleBlock pole = (ElectricFencePoleBlock)blk;
            if (pole.type == this.type) {
                return true;
            }
        }
        if (!((block = (down = world.m_8055_(pos.m_7495_())).m_60734_()) instanceof ElectricFenceWireBlock)) return false;
        ElectricFenceWireBlock wire2 = (ElectricFenceWireBlock)block;
        if (((Direction)down.m_61143_((Property)ElectricFenceWireBlock.UP_DIRECTION)).m_122424_() != dir) return false;
        return true;
    }

    void updateConnectedWires(Level level, BlockPos pos) {
        boolean powered = this.hasPoweredBase((LevelAccessor)level, pos);
        HashSet<BlockPos> wires = new HashSet<BlockPos>();
        HashSet<BlockPos> bases = new HashSet<BlockPos>();
        this.processConnectedWires(bases, wires, level, pos.m_7495_(), pos.m_7495_());
        for (BlockPos wirePos : wires) {
            BlockEntity be = level.m_7702_(wirePos);
            if (!(be instanceof ElectricFenceWireBlockEntity)) continue;
            ElectricFenceWireBlockEntity wire = (ElectricFenceWireBlockEntity)be;
            wire.power(pos, powered);
        }
    }

    private void processConnectedWires(HashSet<BlockPos> bases, HashSet<BlockPos> wires, Level level, BlockPos origin, BlockPos current) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int dZ;
                    int dX;
                    BlockState st;
                    BlockPos offset;
                    if ((dx == dz || dx == -dz) && dy != 0 || !bases.add(offset = current.m_7918_(dx, dy, dz)) || !((st = level.m_8055_(offset)).m_60734_() instanceof ElectricFenceBaseBlock) || (dX = offset.m_123341_() - origin.m_123341_()) * dX + (dZ = offset.m_123343_() - origin.m_123343_()) * dZ > 64) continue;
                    ChunkAccess chunk = level.m_46865_(offset);
                    int y = offset.m_123342_();
                    while (chunk.m_8055_(new BlockPos(offset.m_123341_(), ++y, offset.m_123343_())).m_60734_() instanceof ElectricFenceWireBlock) {
                        wires.add(new BlockPos(offset.m_123341_(), y, offset.m_123343_()));
                    }
                    this.processConnectedWires(bases, wires, level, origin, offset);
                }
            }
        }
    }

    public FenceType getType() {
        return this.type;
    }

    private boolean hasPoweredBase(LevelAccessor level, BlockPos pos) {
        return ElectricFencePoleBlock.hasPoweredBase(level, pos, this.type);
    }

    public static boolean hasPoweredBase(LevelAccessor level, BlockPos polePos, FenceType expectedType) {
        BlockPos.MutableBlockPos cursor = polePos.m_122032_();
        int min = level.m_141937_();
        while (cursor.m_123342_() > min) {
            ElectricFenceWireBlock wire;
            ElectricFencePoleBlock pole;
            cursor.m_122173_(Direction.DOWN);
            BlockState belowState = level.m_8055_((BlockPos)cursor);
            Block block = belowState.m_60734_();
            if (block instanceof ElectricFenceBaseBlock) {
                ElectricFenceBaseBlock base = (ElectricFenceBaseBlock)block;
                if (base.getType() != expectedType) {
                    return false;
                }
                if (level instanceof Level) {
                    Level lvl = (Level)level;
                    return lvl.m_46753_((BlockPos)cursor);
                }
                return false;
            }
            if (!(block instanceof ElectricFencePoleBlock ? (pole = (ElectricFencePoleBlock)block).getType() != expectedType : (block instanceof ElectricFenceWireBlock ? (wire = (ElectricFenceWireBlock)block).getType() != expectedType : !belowState.m_60795_()))) continue;
            return false;
        }
        return false;
    }
}

