/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.fence;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceBaseBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFencePoleBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceWireBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.fence.FenceType;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import org.jetbrains.annotations.Nullable;

public class ElectricFenceWireBlock
extends BaseEntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final DirectionProperty UP_DIRECTION = DirectionProperty.m_156003_((String)"up");
    private final FenceType type;

    public ElectricFenceWireBlock(FenceType type, BlockBehaviour.Properties props) {
        super(props.m_60955_().m_60978_(2.0f));
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_DIRECTION, (Comparable)Direction.DOWN));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        boolean n = (Boolean)state.m_61143_((Property)NORTH);
        boolean s = (Boolean)state.m_61143_((Property)SOUTH);
        boolean w = (Boolean)state.m_61143_((Property)WEST);
        boolean e = (Boolean)state.m_61143_((Property)EAST);
        if (!(n || s || w || e)) {
            e = true;
            w = true;
            s = true;
            n = true;
        }
        double minX = w ? 0.0 : 6.4;
        double maxX = e ? 16.0 : 9.6;
        double minZ = n ? 0.0 : 6.4;
        double maxZ = s ? 16.0 : 9.6;
        return Block.m_49796_((double)minX, (double)0.0, (double)minZ, (double)maxX, (double)16.0, (double)maxZ);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_7731_(pos, this.rebuildConnections((LevelReader)level, pos, state), 3);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            if (!e.getClassName().equals(Sensing.class.getName())) continue;
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, level, pos, ctx);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public RenderShape m_7514_(BlockState s) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{NORTH, SOUTH, WEST, EAST, UP_DIRECTION});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.rebuildConnections((LevelReader)ctx.m_43725_(), ctx.m_8083_(), this.m_49966_());
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.DAMAGE_OTHER;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbour, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        return this.rebuildConnections((LevelReader)level, pos, state);
    }

    protected BlockState rebuildConnections(LevelReader world, BlockPos pos, BlockState state) {
        boolean n = false;
        boolean s = false;
        boolean w = false;
        boolean e = false;
        Direction up = Direction.DOWN;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.m_121945_(dir);
            if (!this.canConnect((BlockGetter)world, pos, offset, world.m_8055_(offset))) continue;
            switch (dir) {
                case NORTH: {
                    n = true;
                    break;
                }
                case SOUTH: {
                    s = true;
                    break;
                }
                case WEST: {
                    w = true;
                    break;
                }
                case EAST: {
                    e = true;
                }
            }
        }
        BlockPos.MutableBlockPos basePos = pos.m_122032_();
        this.findBase((BlockGetter)world, basePos);
        if (world.m_8055_((BlockPos)basePos).m_60734_() instanceof ElectricFenceBaseBlock) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos offset = basePos.m_121945_(dir);
                BlockPos top = offset.m_7494_().m_6630_(this.getFenceHeight(world.m_8055_(offset.m_7494_()), (BlockGetter)world, offset.m_7494_().m_122032_()) + 1);
                if (!this.canConnect(world.m_8055_(top))) continue;
                BlockPos.MutableBlockPos otherBase = top.m_122032_();
                this.findBase((BlockGetter)world, otherBase);
                if (otherBase.m_123342_() < basePos.m_123342_() || !(world.m_8055_((BlockPos)otherBase).m_60734_() instanceof ElectricFenceBaseBlock) || world.m_8055_(offset).m_60734_() instanceof ElectricFenceBaseBlock) continue;
                up = dir;
                break;
            }
        }
        if (!(n || s || w || e)) {
            e = true;
            w = true;
            s = true;
            n = true;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(n))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(s))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(w))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(e))).m_61124_((Property)UP_DIRECTION, (Comparable)up);
    }

    private void findBase(BlockGetter level, BlockPos.MutableBlockPos pos) {
        int drift = 0;
        while (pos.m_123342_() > 1 && !(level.m_8055_((BlockPos)pos).m_60734_() instanceof ElectricFenceBaseBlock) && drift < 5) {
            pos.m_122173_(Direction.DOWN);
            drift = level.m_8055_((BlockPos)pos).m_60734_() instanceof ElectricFenceWireBlock ? 0 : drift + 1;
        }
    }

    private int getFenceHeight(BlockState state, BlockGetter level, BlockPos.MutableBlockPos pos) {
        int height = 0;
        if (state.m_60734_() instanceof ElectricFenceWireBlock) {
            while (pos.m_123342_() < 255 && level.m_8055_((BlockPos)pos).m_60734_() instanceof ElectricFenceWireBlock) {
                pos.m_122173_(Direction.UP);
                ++height;
            }
            pos.m_122175_(Direction.DOWN, height);
            while (pos.m_123342_() > 1 && level.m_8055_((BlockPos)pos).m_60734_() instanceof ElectricFenceWireBlock) {
                pos.m_122173_(Direction.DOWN);
                ++height;
            }
        }
        return height;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canConnect(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof ElectricFenceWireBlock) {
            ElectricFenceWireBlock wire = (ElectricFenceWireBlock)block;
            if (wire.type == this.type) return true;
        }
        if (!(state.m_60734_() instanceof ElectricFencePoleBlock)) return false;
        return true;
    }

    private boolean canConnect(BlockGetter level, BlockPos current, BlockPos pos, BlockState state) {
        if (this.canConnect(state)) {
            return true;
        }
        BlockState down = level.m_8055_(pos.m_7495_());
        return down.m_60734_() instanceof ElectricFenceWireBlock && Math.abs(current.m_123342_() - pos.m_7495_().m_123342_()) == 1;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ElectricFenceWireBlockEntity(pos, state);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbour) {
        BlockEntity be;
        if (!world.m_5776_() && (be = world.m_7702_(pos)) instanceof ElectricFenceWireBlockEntity) {
            ElectricFenceWireBlockEntity wire = (ElectricFenceWireBlockEntity)be;
            wire.checkDisconnect();
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ElectricFenceWireBlockEntity wire;
        if (level.f_46443_ || !entity.m_6084_() || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity liv = (LivingEntity)entity;
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof ElectricFenceWireBlockEntity) || !(wire = (ElectricFenceWireBlockEntity)be).isPowered()) {
            return;
        }
        switch (this.type) {
            case LOW: {
                entity.m_6469_(DamageSource.f_19306_, 1.0f);
                break;
            }
            case MED: {
                entity.m_6469_(DamageSource.f_19306_, 2.0f);
                break;
            }
            case HIGH: {
                entity.m_6469_(DamageSource.f_19306_, 3.0f);
            }
        }
        if (entity instanceof DinosaurEntity) {
            DinosaurEntity dino = (DinosaurEntity)entity;
            if (dino.wireTicks < 2) {
                ++dino.wireTicks;
                dino.disableHerdingTicks = 200;
            }
        }
        if (entity.f_19797_ % 10 == 0) {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundHandler.FENCE_SHOCK, SoundSource.BLOCKS, 0.25f, 1.0f);
        }
    }

    public FenceType getType() {
        return this.type;
    }

    public boolean collisionExtendsVertically(BlockState s, BlockGetter l, BlockPos p, Entity e) {
        return true;
    }
}

