/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.fence;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFencePoleBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceWireBlock;

public class ElectricFenceWireBlockEntity
extends BlockEntity
implements BlockEntityTicker {
    private Set<BlockPos> poweringPoles = new HashSet<BlockPos>();
    private byte ticks;

    public ElectricFenceWireBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.WIRE_FENCE_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public void tick() {
        this.ticks = (byte)(this.ticks + 1);
        if (this.ticks >= 20) {
            this.removeInvalidPoles();
            this.ticks = 0;
        }
    }

    private void removeInvalidPoles() {
        List<BlockPos> invalid = this.getInvalidPoles();
        for (BlockPos remove : invalid) {
            this.power(remove, false);
        }
    }

    public void onLoad() {
        BlockState correct;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (correct = ((ElectricFenceWireBlock)this.m_58900_().m_60734_()).rebuildConnections((LevelReader)this.f_58857_, this.f_58858_, this.m_58900_())) != this.m_58900_()) {
            this.f_58857_.m_7731_(this.f_58858_, correct, 3);
        }
    }

    private List<BlockPos> getInvalidPoles() {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>(this.poweringPoles.size());
        for (BlockPos pole : this.poweringPoles) {
            ElectricFencePoleBlock poleBlock;
            BlockState state = this.f_58857_.m_8055_(pole);
            boolean isInvalid = true;
            Block block = state.m_60734_();
            if (block instanceof ElectricFencePoleBlock && ElectricFencePoleBlock.hasPoweredBase((LevelAccessor)this.f_58857_, pole, (poleBlock = (ElectricFencePoleBlock)block).getType())) {
                isInvalid = false;
            }
            if (!isInvalid) continue;
            invalid.add(pole);
        }
        return invalid;
    }

    public void checkDisconnect() {
        this.removeInvalidPoles();
        for (BlockPos pole : this.poweringPoles) {
            BlockState state = this.f_58857_.m_8055_(pole);
            Block block = state.m_60734_();
            if (!(block instanceof ElectricFencePoleBlock)) continue;
            ((ElectricFencePoleBlock)block).updateConnectedWires(this.f_58857_, pole);
        }
    }

    public void power(BlockPos pole, boolean powered) {
        if (powered) {
            if (!this.poweringPoles.contains(pole)) {
                this.poweringPoles.add(pole);
            }
        } else {
            this.poweringPoles.remove(pole);
        }
    }

    public boolean isPowered() {
        return this.poweringPoles.size() > 0;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        ListTag poweringList = new ListTag();
        for (BlockPos pole : this.poweringPoles) {
            poweringList.add((Object)LongTag.m_128882_((long)pole.m_121878_()));
        }
        compound.m_128365_("Powering", (Tag)poweringList);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.poweringPoles.clear();
        ListTag poweringList = compound.m_128437_("Powering", 4);
        for (int i = 0; i < poweringList.size(); ++i) {
            this.poweringPoles.add(BlockPos.m_122022_((long)((LongTag)poweringList.get(i)).m_7046_()));
        }
    }

    public void m_155252_(Level pLevel, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        ((ElectricFenceWireBlockEntity)pBlockEntity).m_155252_(pLevel, pPos, pState, pBlockEntity);
    }
}

