/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.parkBlocks;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.vit.jurassicreborn.common.blocks.parkBlocks.TourRailBlockEntity;
import net.vit.jurassicreborn.common.entities.vehicle.VehicleEntity;
import org.jetbrains.annotations.Nullable;

public class TourRailBlock
extends Block
implements EntityBlock {
    public static EnumProperty<EnumRailDirection> SHAPE = EnumProperty.m_61587_((String)"shape", EnumRailDirection.class);
    public static final VoxelShape FLAT = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.9999, (double)2.0, (double)16.0);
    public static final VoxelShape ASCENDING = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.9999, (double)8.0, (double)16.0);
    private final SpeedType speedType;

    public TourRailBlock(BlockBehaviour.Properties p_49795_, SpeedType speedType) {
        super(p_49795_);
        this.speedType = speedType;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(SHAPE, (Comparable)((Object)EnumRailDirection.NORTH_SOUTH)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{SHAPE});
    }

    public SpeedType getSpeedType() {
        return this.speedType;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TourRailBlockEntity(pos, state);
    }

    public static EnumRailDirection getRailDirection(Level world, BlockPos pos) {
        return world.m_7702_(pos) instanceof TourRailBlockEntity ? ((TourRailBlockEntity)world.m_7702_(pos)).getDirection() : EnumRailDirection.NORTH_SOUTH;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ((EnumRailDirection)((Object)pState.m_61143_(SHAPE))).isAscending() ? ASCENDING : FLAT;
    }

    public boolean m_7898_(BlockState pState, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)worldIn, pos.m_7495_(), Direction.UP);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        this.updateDir(pLevel, pPos, pState, true);
        if (pLevel.f_46443_) {
            return;
        }
        pState.m_60690_(pLevel, pPos, (Block)this, pPos, pIsMoving);
    }

    public BlockState getStateAtViewpoint(BlockState state, BlockGetter level, BlockPos pos, Vec3 viewpoint) {
        return level.m_7702_(pos) instanceof TourRailBlockEntity ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)TourRailBlock.getRailDirection(level, pos))) : this.m_49966_();
    }

    public static EnumRailDirection getRailDirection(BlockGetter world, BlockPos pos) {
        EnumRailDirection enumRailDirection;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TourRailBlockEntity) {
            TourRailBlockEntity entity = (TourRailBlockEntity)blockEntity;
            enumRailDirection = entity.getDirection();
        } else {
            enumRailDirection = EnumRailDirection.NORTH_SOUTH;
        }
        return enumRailDirection;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        if (!pLevel.f_46443_) {
            pLevel.markAndNotifyBlock(pPos, pLevel.m_46745_(pPos), pState, pNewState, 3, 512);
        }
    }

    private BlockState updateDir(Level worldIn, BlockPos pos, BlockState state, boolean initialPlacement) {
        return new Rail(worldIn, pos, state).place(initialPlacement).getBlockState();
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean pIsMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        EnumRailDirection dir = TourRailBlock.getRailDirection(worldIn, pos);
        boolean flag = false;
        if (!worldIn.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)worldIn, pos.m_7495_(), Direction.UP)) {
            flag = true;
        }
        if (dir == EnumRailDirection.ASCENDING_EAST && !worldIn.m_8055_(pos.m_122029_()).m_60783_((BlockGetter)worldIn, pos.m_122029_(), Direction.UP)) {
            flag = true;
        } else if (dir == EnumRailDirection.ASCENDING_WEST && !worldIn.m_8055_(pos.m_122024_()).m_60783_((BlockGetter)worldIn, pos.m_122024_(), Direction.UP)) {
            flag = true;
        } else if (dir == EnumRailDirection.ASCENDING_NORTH && !worldIn.m_8055_(pos.m_122012_()).m_60783_((BlockGetter)worldIn, pos.m_122012_(), Direction.UP)) {
            flag = true;
        } else if (dir == EnumRailDirection.ASCENDING_SOUTH && !worldIn.m_8055_(pos.m_122019_()).m_60783_((BlockGetter)worldIn, pos.m_122019_(), Direction.UP)) {
            flag = true;
        }
        if (flag && !worldIn.m_8055_(pos).m_60795_()) {
            worldIn.m_46961_(pos, true);
        } else {
            this.updateDir(worldIn, pos, state, false);
        }
    }

    public static boolean isRailBlock(Level worldIn, BlockPos pos) {
        return TourRailBlock.isRailBlock(worldIn.m_8055_(pos));
    }

    public static boolean isRailBlock(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof TourRailBlock;
    }

    public static enum SpeedType {
        NONE(null, -1),
        SLOW(VehicleEntity.Speed.SLOW, 0xA80000),
        MEDIUM(VehicleEntity.Speed.MEDIUM, 16741888),
        FAST(VehicleEntity.Speed.FAST, 43008);

        private final VehicleEntity.Speed speed;
        private final int color;

        private SpeedType(VehicleEntity.Speed speed, int color) {
            this.speed = speed;
            this.color = color;
        }

        @Nonnull
        public VehicleEntity.Speed getSpeed(VehicleEntity.Speed defaultSpeed) {
            return this.speed == null ? defaultSpeed : this.speed;
        }

        @Nonnull
        public int getColor() {
            return this.color;
        }
    }

    public static enum EnumRailDirection implements Serializable,
    StringRepresentable
    {
        NORTH_SOUTH(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0, "tour_rail_straight"),
        EAST_WEST(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 90, "tour_rail_straight"),
        SOUTH_EAST(0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 270, "tour_rail_corner"),
        SOUTH_WEST(0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 180, "tour_rail_corner"),
        NORTH_WEST(0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, 90, "tour_rail_corner"),
        NORTH_EAST(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0, "tour_rail_corner"),
        ASCENDING_EAST(-1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 90, "tour_rail_slope"),
        ASCENDING_WEST(-1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 270, "tour_rail_slope"),
        ASCENDING_NORTH(0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 1.0f, 180, "tour_rail_slope"),
        ASCENDING_SOUTH(0.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0, "tour_rail_slope"),
        DIAGONAL_NE_SW(0.5f, 0.0f, -0.5f, -0.5f, 0.0f, 0.5f, 90, "tour_rail_diagonal"),
        DIAGONAL_NW_SE(0.5f, 0.0f, 0.5f, -0.5f, 0.0f, -0.5f, 0, "tour_rail_diagonal"),
        HORIZONTAL_NE(Direction.NORTH, Direction.EAST, DIAGONAL_NE_SW, EAST_WEST, 90, "tour_rail_diagonal_turn_right"),
        HORIZONTAL_NW(Direction.NORTH, Direction.WEST, DIAGONAL_NW_SE, EAST_WEST, 270, "tour_rail_diagonal_turn_left"),
        HORIZONTAL_SE(Direction.SOUTH, Direction.EAST, DIAGONAL_NW_SE, EAST_WEST, 90, "tour_rail_diagonal_turn_left"),
        HORIZONTAL_SW(Direction.SOUTH, Direction.WEST, DIAGONAL_NE_SW, EAST_WEST, 270, "tour_rail_diagonal_turn_right"),
        VERTICAL_NE(Direction.NORTH, Direction.EAST, DIAGONAL_NE_SW, NORTH_SOUTH, 180, "tour_rail_diagonal_turn_left"),
        VERTICAL_NW(Direction.NORTH, Direction.WEST, DIAGONAL_NW_SE, NORTH_SOUTH, 180, "tour_rail_diagonal_turn_right"),
        VERTICAL_SE(Direction.SOUTH, Direction.EAST, DIAGONAL_NW_SE, NORTH_SOUTH, 0, "tour_rail_diagonal_turn_right"),
        VERTICAL_SW(Direction.SOUTH, Direction.WEST, DIAGONAL_NE_SW, NORTH_SOUTH, 0, "tour_rail_diagonal_turn_left");

        private final Type type;
        private float forwardX;
        private float forwardY;
        private float forwardZ;
        private float backwardsX;
        private float backwardsY;
        private float backwardsZ;
        private Predicate<Direction> facingPredicate;
        private EnumRailDirection diagonalDirection;
        private EnumRailDirection straightDirection;
        public final int rotation;
        public final String modelName;

        private EnumRailDirection(float forwardX, float forward_y, float forward_z, float backwards_x, float backwards_y, float backwards_z, int rotation, String modelId) {
            this.forwardX = forwardX;
            this.forwardY = forward_y;
            this.forwardZ = forward_z;
            this.backwardsX = backwards_x;
            this.backwardsY = backwards_y;
            this.backwardsZ = backwards_z;
            this.type = Type.VALUE;
            this.rotation = rotation;
            this.modelName = modelId;
        }

        private EnumRailDirection(Direction facing, Direction facing2, EnumRailDirection diagonalDirection, EnumRailDirection straightDirection, int rotation, String modelId) {
            this.type = Type.COPYCAT;
            this.facingPredicate = face -> face == facing || face == facing2;
            this.diagonalDirection = diagonalDirection;
            this.straightDirection = straightDirection;
            this.rotation = rotation;
            this.modelName = modelId;
        }

        public boolean isAscending() {
            return this == ASCENDING_NORTH || this == ASCENDING_EAST || this == ASCENDING_SOUTH || this == ASCENDING_WEST;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public float getForwardX(Direction face) {
            if (this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getForwardX(null);
            }
            return this.forwardX;
        }

        public float getForwardY(Direction face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getForwardY(null);
            }
            return this.forwardY;
        }

        public float getForwardZ(Direction face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getForwardZ(null);
            }
            return this.forwardZ;
        }

        public float getBackwardsX(Direction face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getBackwardsX(null);
            }
            return this.backwardsX;
        }

        public float getBackwardsY(Direction face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getBackwardsY(null);
            }
            return this.backwardsY;
        }

        public float getBackwardsZ(Direction face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getBackwardsZ(null);
            }
            return this.backwardsZ;
        }

        public Direction getFacing() {
            return switch (this) {
                case ASCENDING_EAST -> Direction.EAST;
                case ASCENDING_WEST -> Direction.WEST;
                case ASCENDING_NORTH -> Direction.NORTH;
                case ASCENDING_SOUTH -> Direction.SOUTH;
                default -> Direction.NORTH;
            };
        }

        public String m_7912_() {
            return this.toString();
        }

        public String getName() {
            return this.name();
        }

        private static enum Type {
            VALUE,
            COPYCAT;

        }
    }

    public class Rail {
        private final Level world;
        private final BlockPos pos;
        private final TourRailBlock block;
        private BlockState state;
        private final List<BlockPos> connectedRails = Lists.newArrayList();

        public Rail(Level worldIn, BlockPos pos, BlockState state) {
            this.world = worldIn;
            this.pos = pos;
            this.state = state;
            this.block = (TourRailBlock)state.m_60734_();
            EnumRailDirection TourRailBlock$enumraildirection = TourRailBlock.getRailDirection(worldIn, pos);
            this.updateConnectedRails(TourRailBlock$enumraildirection);
        }

        public List<BlockPos> getConnectedRails() {
            return this.connectedRails;
        }

        private void updateConnectedRails(EnumRailDirection railDirection) {
            this.connectedRails.clear();
            switch (railDirection) {
                case NORTH_SOUTH: {
                    this.connectedRails.add(this.pos.m_122012_());
                    this.connectedRails.add(this.pos.m_122019_());
                    break;
                }
                case EAST_WEST: {
                    this.connectedRails.add(this.pos.m_122024_());
                    this.connectedRails.add(this.pos.m_122029_());
                    break;
                }
                case ASCENDING_EAST: {
                    this.connectedRails.add(this.pos.m_122024_());
                    this.connectedRails.add(this.pos.m_122029_().m_7494_());
                    break;
                }
                case ASCENDING_WEST: {
                    this.connectedRails.add(this.pos.m_122024_().m_7494_());
                    this.connectedRails.add(this.pos.m_122029_());
                    break;
                }
                case ASCENDING_NORTH: {
                    this.connectedRails.add(this.pos.m_122012_().m_7494_());
                    this.connectedRails.add(this.pos.m_122019_());
                    break;
                }
                case ASCENDING_SOUTH: {
                    this.connectedRails.add(this.pos.m_122012_());
                    this.connectedRails.add(this.pos.m_122019_().m_7494_());
                    break;
                }
                case SOUTH_EAST: {
                    this.connectedRails.add(this.pos.m_122029_());
                    this.connectedRails.add(this.pos.m_122019_());
                    break;
                }
                case SOUTH_WEST: {
                    this.connectedRails.add(this.pos.m_122024_());
                    this.connectedRails.add(this.pos.m_122019_());
                    break;
                }
                case NORTH_WEST: {
                    this.connectedRails.add(this.pos.m_122024_());
                    this.connectedRails.add(this.pos.m_122012_());
                    break;
                }
                case NORTH_EAST: {
                    this.connectedRails.add(this.pos.m_122029_());
                    this.connectedRails.add(this.pos.m_122012_());
                    break;
                }
                case DIAGONAL_NE_SW: {
                    this.connectedRails.add(this.pos.m_122012_().m_122029_());
                    this.connectedRails.add(this.pos.m_122019_().m_122024_());
                    break;
                }
                case DIAGONAL_NW_SE: {
                    this.connectedRails.add(this.pos.m_122012_().m_122024_());
                    this.connectedRails.add(this.pos.m_122019_().m_122029_());
                    break;
                }
                case HORIZONTAL_NE: {
                    this.connectedRails.add(this.pos.m_122024_());
                    this.connectedRails.add(this.pos.m_122012_().m_122029_());
                    break;
                }
                case HORIZONTAL_SE: {
                    this.connectedRails.add(this.pos.m_122024_());
                    this.connectedRails.add(this.pos.m_122019_().m_122029_());
                    break;
                }
                case HORIZONTAL_NW: {
                    this.connectedRails.add(this.pos.m_122029_());
                    this.connectedRails.add(this.pos.m_122012_().m_122024_());
                    break;
                }
                case HORIZONTAL_SW: {
                    this.connectedRails.add(this.pos.m_122029_());
                    this.connectedRails.add(this.pos.m_122019_().m_122024_());
                    break;
                }
                case VERTICAL_NE: {
                    this.connectedRails.add(this.pos.m_122019_());
                    this.connectedRails.add(this.pos.m_122012_().m_122029_());
                    break;
                }
                case VERTICAL_SE: {
                    this.connectedRails.add(this.pos.m_122012_());
                    this.connectedRails.add(this.pos.m_122019_().m_122029_());
                    break;
                }
                case VERTICAL_NW: {
                    this.connectedRails.add(this.pos.m_122019_());
                    this.connectedRails.add(this.pos.m_122012_().m_122024_());
                    break;
                }
                case VERTICAL_SW: {
                    this.connectedRails.add(this.pos.m_122012_());
                    this.connectedRails.add(this.pos.m_122019_().m_122024_());
                }
            }
        }

        private void removeSoftConnections() {
            for (int i = 0; i < this.connectedRails.size(); ++i) {
                Rail TourRailBlock$rail = this.findRailAt(this.connectedRails.get(i));
                if (TourRailBlock$rail != null && TourRailBlock$rail.isConnectedToRail(this)) {
                    this.connectedRails.set(i, TourRailBlock$rail.pos);
                    continue;
                }
                this.connectedRails.remove(i--);
            }
        }

        private boolean hasRailAt(BlockPos pos) {
            return TourRailBlock.isRailBlock(this.world, pos) || TourRailBlock.isRailBlock(this.world, pos.m_7494_()) || TourRailBlock.isRailBlock(this.world, pos.m_7495_());
        }

        @Nullable
        private Rail findRailAt(BlockPos pos) {
            Rail rail;
            BlockState iblockstate = this.world.m_8055_(pos);
            if (TourRailBlock.isRailBlock(iblockstate)) {
                TourRailBlock tourRailBlock = TourRailBlock.this;
                Objects.requireNonNull(tourRailBlock);
                return tourRailBlock.new Rail(this.world, pos, iblockstate);
            }
            BlockPos lvt_2_1_ = pos.m_7494_();
            iblockstate = this.world.m_8055_(lvt_2_1_);
            if (TourRailBlock.isRailBlock(iblockstate)) {
                TourRailBlock tourRailBlock = TourRailBlock.this;
                Objects.requireNonNull(tourRailBlock);
                return tourRailBlock.new Rail(this.world, lvt_2_1_, iblockstate);
            }
            lvt_2_1_ = pos.m_7495_();
            iblockstate = this.world.m_8055_(lvt_2_1_);
            if (TourRailBlock.isRailBlock(iblockstate)) {
                TourRailBlock tourRailBlock = TourRailBlock.this;
                Objects.requireNonNull(tourRailBlock);
                rail = tourRailBlock.new Rail(this.world, lvt_2_1_, iblockstate);
            } else {
                rail = null;
            }
            return rail;
        }

        private boolean isConnectedToRail(Rail rail) {
            return this.isConnectedTo(rail.pos);
        }

        private boolean isConnectedTo(BlockPos posIn) {
            for (int i = 0; i < this.connectedRails.size(); ++i) {
                BlockPos blockpos = this.connectedRails.get(i);
                if (blockpos.m_123341_() != posIn.m_123341_() || blockpos.m_123343_() != posIn.m_123343_()) continue;
                return true;
            }
            return false;
        }

        protected int countAdjacentRails() {
            int i = 0;
            for (Direction enumfacing : Direction.Plane.HORIZONTAL) {
                if (!this.hasRailAt(this.pos.m_121945_(enumfacing))) continue;
                ++i;
            }
            for (int i1 = 0; i1 < 4; ++i1) {
                if (!this.hasRailAt(this.pos.m_122013_(i1 % 2 == 0 ? 1 : -1).m_122030_(Math.floorDiv(i1, 2) == 0 ? 1 : -1))) continue;
                ++i;
            }
            return i;
        }

        private boolean canConnectTo(Rail rail) {
            return this.isConnectedToRail(rail) || this.connectedRails.size() <= 2;
        }

        private void connectTo(Rail rail) {
            this.connectedRails.add(rail.pos);
            BlockPos blockpos = this.pos.m_122012_();
            BlockPos blockpos1 = this.pos.m_122019_();
            BlockPos blockpos2 = this.pos.m_122024_();
            BlockPos blockpos3 = this.pos.m_122029_();
            boolean flag = this.isConnectedTo(blockpos);
            boolean flag1 = this.isConnectedTo(blockpos1);
            boolean flag2 = this.isConnectedTo(blockpos2);
            boolean flag3 = this.isConnectedTo(blockpos3);
            EnumRailDirection railDirection = null;
            if (flag || flag1) {
                railDirection = EnumRailDirection.NORTH_SOUTH;
            }
            if (flag2 || flag3) {
                railDirection = EnumRailDirection.EAST_WEST;
            }
            if (flag1 && flag3 && !flag && !flag2) {
                railDirection = EnumRailDirection.SOUTH_EAST;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                railDirection = EnumRailDirection.SOUTH_WEST;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                railDirection = EnumRailDirection.NORTH_WEST;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                railDirection = EnumRailDirection.NORTH_EAST;
            }
            if (railDirection == EnumRailDirection.NORTH_SOUTH) {
                if (TourRailBlock.isRailBlock(this.world, blockpos.m_7494_())) {
                    railDirection = EnumRailDirection.ASCENDING_NORTH;
                }
                if (TourRailBlock.isRailBlock(this.world, blockpos1.m_7494_())) {
                    railDirection = EnumRailDirection.ASCENDING_SOUTH;
                }
            }
            if (railDirection == EnumRailDirection.EAST_WEST) {
                if (TourRailBlock.isRailBlock(this.world, blockpos3.m_7494_())) {
                    railDirection = EnumRailDirection.ASCENDING_EAST;
                }
                if (TourRailBlock.isRailBlock(this.world, blockpos2.m_7494_())) {
                    railDirection = EnumRailDirection.ASCENDING_WEST;
                }
            }
            if (railDirection == null) {
                BlockPos nw = this.pos.m_122012_().m_122024_();
                BlockPos ne = this.pos.m_122012_().m_122029_();
                BlockPos sw = this.pos.m_122019_().m_122024_();
                BlockPos se = this.pos.m_122019_().m_122029_();
                boolean can_nw = this.isConnectedTo(nw);
                boolean can_ne = this.isConnectedTo(ne);
                boolean can_sw = this.isConnectedTo(sw);
                boolean can_se = this.isConnectedTo(se);
                railDirection = can_ne || can_sw ? EnumRailDirection.DIAGONAL_NE_SW : (can_nw || can_se ? EnumRailDirection.DIAGONAL_NW_SE : EnumRailDirection.NORTH_SOUTH);
            }
            boolean connectDiag = false;
            Object connectionName = "";
            if (railDirection == EnumRailDirection.NORTH_SOUTH) {
                connectionName = (String)connectionName + "VERTICAL_";
                boolean connectedNorth = this.isConnectedTo(this.pos.m_122012_());
                boolean connectedSouth = this.isConnectedTo(this.pos.m_122019_());
                if (!connectedNorth || !connectedSouth) {
                    connectionName = (String)connectionName + (connectedNorth ? "S" : "N");
                    BlockPos connectPos = this.pos.m_122013_(connectedNorth ? -1 : 1);
                    if (this.isConnectedTo(connectPos.m_122029_())) {
                        connectionName = (String)connectionName + "E";
                        connectDiag = true;
                    } else if (this.isConnectedTo(connectPos.m_122024_())) {
                        connectionName = (String)connectionName + "W";
                        connectDiag = true;
                    }
                }
            } else if (railDirection == EnumRailDirection.EAST_WEST) {
                connectionName = (String)connectionName + "HORIZONTAL_";
                boolean connectedEast = this.isConnectedTo(this.pos.m_122029_());
                boolean connectedWest = this.isConnectedTo(this.pos.m_122024_());
                if (!connectedEast || !connectedWest) {
                    String suffix = connectedEast ? "W" : "E";
                    BlockPos connectPos = this.pos.m_122030_(connectedEast ? -1 : 1);
                    if (this.isConnectedTo(connectPos.m_122012_())) {
                        connectionName = (String)connectionName + "N";
                        connectDiag = true;
                    } else if (this.isConnectedTo(connectPos.m_122019_())) {
                        connectionName = (String)connectionName + "S";
                        connectDiag = true;
                    }
                    connectionName = (String)connectionName + suffix;
                }
            }
            if (connectDiag) {
                railDirection = EnumRailDirection.valueOf((String)connectionName);
            }
            this.state = (BlockState)this.state.m_61124_(SHAPE, (Comparable)((Object)railDirection));
            this.world.m_7731_(this.pos, this.state, 3);
            BlockEntity blockEntity = this.world.m_7702_(this.pos);
            if (blockEntity instanceof TourRailBlockEntity) {
                TourRailBlockEntity tourRailBlockEntity = (TourRailBlockEntity)blockEntity;
                tourRailBlockEntity.setDirection(railDirection);
            }
        }

        private boolean hasNeighborRail(BlockPos posIn) {
            Rail TourRailBlock$rail = this.findRailAt(posIn);
            if (TourRailBlock$rail == null) {
                return false;
            }
            TourRailBlock$rail.removeSoftConnections();
            return TourRailBlock$rail.canConnectTo(this);
        }

        public Rail place(boolean initialPlacement) {
            TourRailBlockEntity tourRailBlockEntity;
            BlockPos blockpos = this.pos.m_122012_();
            BlockPos blockpos1 = this.pos.m_122019_();
            BlockPos blockpos2 = this.pos.m_122024_();
            BlockPos blockpos3 = this.pos.m_122029_();
            boolean flag = this.hasNeighborRail(blockpos);
            boolean flag1 = this.hasNeighborRail(blockpos1);
            boolean flag2 = this.hasNeighborRail(blockpos2);
            boolean flag3 = this.hasNeighborRail(blockpos3);
            EnumRailDirection railDirection = null;
            if ((flag || flag1) && !flag2 && !flag3) {
                railDirection = EnumRailDirection.NORTH_SOUTH;
            }
            if ((flag2 || flag3) && !flag && !flag1) {
                railDirection = EnumRailDirection.EAST_WEST;
            }
            if (flag1 && flag3 && !flag && !flag2) {
                railDirection = EnumRailDirection.SOUTH_EAST;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                railDirection = EnumRailDirection.SOUTH_WEST;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                railDirection = EnumRailDirection.NORTH_WEST;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                railDirection = EnumRailDirection.NORTH_EAST;
            }
            if (railDirection == null) {
                if (flag || flag1) {
                    railDirection = EnumRailDirection.NORTH_SOUTH;
                }
                if (flag2 || flag3) {
                    railDirection = EnumRailDirection.EAST_WEST;
                }
            }
            if (railDirection == EnumRailDirection.NORTH_SOUTH) {
                if (TourRailBlock.isRailBlock(this.world, blockpos.m_7494_())) {
                    railDirection = EnumRailDirection.ASCENDING_NORTH;
                }
                if (TourRailBlock.isRailBlock(this.world, blockpos1.m_7494_())) {
                    railDirection = EnumRailDirection.ASCENDING_SOUTH;
                }
            }
            if (railDirection == EnumRailDirection.EAST_WEST) {
                if (TourRailBlock.isRailBlock(this.world, blockpos3.m_7494_())) {
                    railDirection = EnumRailDirection.ASCENDING_EAST;
                }
                if (TourRailBlock.isRailBlock(this.world, blockpos2.m_7494_())) {
                    railDirection = EnumRailDirection.ASCENDING_WEST;
                }
            }
            if (railDirection == null) {
                BlockPos nw = this.pos.m_122012_().m_122024_();
                BlockPos ne = this.pos.m_122012_().m_122029_();
                BlockPos sw = this.pos.m_122019_().m_122024_();
                BlockPos se = this.pos.m_122019_().m_122029_();
                boolean can_nw = this.hasNeighborRail(nw);
                boolean can_ne = this.hasNeighborRail(ne);
                boolean can_sw = this.hasNeighborRail(sw);
                boolean can_se = this.hasNeighborRail(se);
                railDirection = can_ne || can_sw ? EnumRailDirection.DIAGONAL_NE_SW : (can_nw || can_se ? EnumRailDirection.DIAGONAL_NW_SE : EnumRailDirection.NORTH_SOUTH);
            }
            boolean connectDiag = false;
            StringBuilder connectionName = new StringBuilder();
            if (railDirection == EnumRailDirection.NORTH_SOUTH) {
                connectionName.append("VERTICAL_");
                boolean connectedNorth = this.hasNeighborRail(this.pos.m_122012_());
                boolean connectedSouth = this.hasNeighborRail(this.pos.m_122019_());
                if (!connectedNorth || !connectedSouth) {
                    connectionName.append(connectedNorth ? "S" : "N");
                    BlockPos connectPos = this.pos.m_122013_(connectedNorth ? -1 : 1);
                    if (this.hasNeighborRail(connectPos.m_122029_())) {
                        connectionName.append("E");
                        connectDiag = true;
                    } else if (this.hasNeighborRail(connectPos.m_122024_())) {
                        connectionName.append("W");
                        connectDiag = true;
                    }
                }
            } else if (railDirection == EnumRailDirection.EAST_WEST) {
                connectionName.append("HORIZONTAL_");
                boolean connectedEast = this.hasNeighborRail(this.pos.m_122029_());
                boolean connectedWest = this.hasNeighborRail(this.pos.m_122024_());
                if (!connectedEast || !connectedWest) {
                    String suffix = connectedEast ? "W" : "E";
                    BlockPos connectPos = this.pos.m_122030_(connectedEast ? -1 : 1);
                    if (this.hasNeighborRail(connectPos.m_122012_())) {
                        connectionName.append("N");
                        connectDiag = true;
                    } else if (this.hasNeighborRail(connectPos.m_122019_())) {
                        connectionName.append("S");
                        connectDiag = true;
                    }
                    connectionName.append(suffix);
                }
            }
            if (connectDiag) {
                railDirection = EnumRailDirection.valueOf(connectionName.toString());
            }
            this.state = (BlockState)this.state.m_61124_(SHAPE, (Comparable)((Object)railDirection));
            this.updateConnectedRails(railDirection);
            BlockEntity blockEntity = this.world.m_7702_(this.pos);
            TourRailBlockEntity tourRailBlockEntity2 = tourRailBlockEntity = blockEntity instanceof TourRailBlockEntity ? (TourRailBlockEntity)blockEntity : null;
            if (initialPlacement || tourRailBlockEntity != null && tourRailBlockEntity.getDirection() != railDirection) {
                this.world.m_7731_(this.pos, this.state, 3);
                BlockEntity updatedEntity = this.world.m_7702_(this.pos);
                if (updatedEntity instanceof TourRailBlockEntity) {
                    TourRailBlockEntity tourRail = (TourRailBlockEntity)updatedEntity;
                    tourRail.setDirection(railDirection);
                }
                for (int i = 0; i < this.connectedRails.size(); ++i) {
                    Rail TourRailBlock$rail = this.findRailAt(this.connectedRails.get(i));
                    if (TourRailBlock$rail == null) continue;
                    TourRailBlock$rail.removeSoftConnections();
                    if (!TourRailBlock$rail.canConnectTo(this)) continue;
                    TourRailBlock$rail.connectTo(this);
                }
            }
            return this;
        }

        public BlockState getBlockState() {
            return this.state;
        }
    }
}

