/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.wood;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;

public class AncientLeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IForgeShearable {
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)14);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public final int decayDistance;

    public AncientLeavesBlock(BlockBehaviour.Properties pProperties) {
        this(pProperties, 14);
    }

    public AncientLeavesBlock(BlockBehaviour.Properties pProperties, int decayDistance) {
        super(pProperties);
        this.decayDistance = decayDistance;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(1))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)DISTANCE) >= this.decayDistance && (Boolean)pState.m_61143_((Property)PERSISTENT) == false;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.decaying(pState)) {
            AncientLeavesBlock.m_49950_((BlockState)pState, (Level)pLevel, (BlockPos)pPos);
            pLevel.m_7471_(pPos, false);
        }
    }

    protected boolean decaying(BlockState state) {
        return (Boolean)state.m_61143_((Property)PERSISTENT) == false && (Integer)state.m_61143_((Property)DISTANCE) >= this.decayDistance;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7731_(pPos, this.updateDistance(pState, (LevelAccessor)pLevel, pPos), 3);
    }

    public int m_7753_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        int i;
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if ((i = this.getDistanceAt(pFacingState) + 1) != 1 || (Integer)pState.m_61143_((Property)DISTANCE) != i) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    private BlockState updateDistance(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = this.decayDistance;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.m_122159_((Vec3i)pPos, direction);
            i = Math.min(i, this.getDistanceAt(pLevel.m_8055_((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)pState.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private int getDistanceAt(BlockState pNeighbor) {
        if (pNeighbor.m_204336_(BlockTags.f_13106_)) {
            return 0;
        }
        if (pNeighbor.m_60734_() instanceof AncientLeavesBlock) {
            return (Integer)pNeighbor.m_61143_((Property)DISTANCE);
        }
        if (pNeighbor.m_60734_() instanceof LeavesBlock) {
            return (Integer)pNeighbor.m_61143_((Property)LeavesBlock.f_54418_);
        }
        return this.decayDistance;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!pLevel.m_46758_(pPos.m_7494_()) || pRandom.m_188503_(15) != 1 || (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)pLevel, blockpos, Direction.UP))) {
            double d0 = (double)pPos.m_123341_() + pRandom.m_188500_();
            double d1 = (double)pPos.m_123342_() - 0.05;
            double d2 = (double)pPos.m_123343_() + pRandom.m_188500_();
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return this.updateDistance(blockstate, (LevelAccessor)pContext.m_43725_(), pContext.m_8083_());
    }
}

