/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.wood;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.util.api.GrindableItem;

public class PetrifiedLogBlock
extends RotatedPillarBlock
implements GrindableItem {
    private final Plant plant;

    public PetrifiedLogBlock(Plant plant, BlockBehaviour.Properties properties) {
        super(properties);
        this.plant = plant;
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        CompoundTag tag = stack.m_41783_();
        int outputType = random.nextInt(4);
        if (outputType == 3) {
            ItemStack tissue = this.getTissueItem();
            if (!tissue.m_41619_()) {
                tissue.m_41751_(tag);
                return tissue;
            }
        } else if (outputType < 2) {
            return new ItemStack((ItemLike)Items.f_42499_);
        }
        return new ItemStack((ItemLike)Items.f_42484_);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        CompoundTag tag = inputItem.m_41783_();
        float single = 25.0f;
        ItemStack tissue = this.getTissueItem();
        if (!tissue.m_41619_()) {
            tissue.m_41751_(tag);
            list.add(Pair.of((Object)Float.valueOf(single), (Object)tissue));
        }
        list.add(Pair.of((Object)Float.valueOf(50.0f), (Object)new ItemStack((ItemLike)Items.f_42499_)));
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack((ItemLike)Items.f_42484_)));
        return list;
    }

    private ItemStack getTissueItem() {
        String id = this.plant.getFormattedName().toLowerCase(Locale.ROOT).replace(" ", "_");
        ResourceLocation tissueId = new ResourceLocation("jurassicreborn", "soft_tissue/plants/soft_tissue_" + id);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(tissueId);
        return item == null || item == Items.f_41852_ ? ItemStack.f_41583_ : new ItemStack((ItemLike)item);
    }
}

