/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.vit.jurassicreborn.common.worldgen.structure.AbandonedPaddockGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.AmberMineGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.DesertDigsiteGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.IceFossilDigsiteGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.IslaSornaLabGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.JPSanDiegoGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.RaptorPaddockGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.StructureGenerator;
import net.vit.jurassicreborn.common.worldgen.structure.VisitorCentreGenerator;

public class SpawnStructureCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(SpawnStructureCommand.build());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.m_82127_((String)"spawnrb").requires(s -> s.m_6761_(2));
        ArgumentBuilder structure = ((RequiredArgumentBuilder)Commands.m_82129_((String)"structure", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> {
            Stream.of("visitor_center", "abandoned_paddock", "ice_fossil_digsite", "desert_digsite", "amber_mine", "raptor_paddock", "isla_sorna_lab", "jp_san_diego").forEach(arg_0 -> ((SuggestionsBuilder)b).suggest(arg_0));
            return b.buildFuture();
        }).executes(SpawnStructureCommand::run)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"rotation", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> {
            for (Rotation r : Rotation.values()) {
                b.suggest(r.name().toLowerCase(Locale.ROOT));
            }
            return b.buildFuture();
        }).executes(SpawnStructureCommand::run)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mirror", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> {
            for (Mirror m : Mirror.values()) {
                b.suggest(m.name().toLowerCase(Locale.ROOT));
            }
            return b.buildFuture();
        }).executes(SpawnStructureCommand::run)).then(Commands.m_82129_((String)"seed", (ArgumentType)LongArgumentType.longArg()).executes(SpawnStructureCommand::run))));
        root.then(structure);
        return root;
    }

    private static boolean hasArg(CommandContext<CommandSourceStack> ctx, String name) {
        return ctx.getNodes().stream().anyMatch(n -> n.getNode().getName().equals(name));
    }

    private static int run(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"structure");
        RandomSource random = RandomSource.m_216327_();
        StructureGenerator generator = switch (name.toLowerCase(Locale.ROOT)) {
            case "visitor_center" -> new VisitorCentreGenerator(random);
            case "raptor_paddock" -> new RaptorPaddockGenerator(random);
            case "abandoned_paddock" -> new AbandonedPaddockGenerator(random);
            case "ice_fossil_digsite" -> new IceFossilDigsiteGenerator(random);
            case "desert_digsite" -> new DesertDigsiteGenerator(random);
            case "amber_mine" -> new AmberMineGenerator(random);
            case "isla_sorna_lab" -> new IslaSornaLabGenerator(random);
            case "jp_san_diego" -> new JPSanDiegoGenerator(random);
            default -> throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"commands.spawnrb.notfound", (Object[])new Object[]{name})).create();
        };
        if (SpawnStructureCommand.hasArg(ctx, "rotation")) {
            String rot = StringArgumentType.getString(ctx, (String)"rotation");
            try {
                generator.setRotation(Rotation.valueOf((String)rot.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"commands.spawnrb.notrot", (Object[])new Object[]{rot})).create();
            }
        }
        if (SpawnStructureCommand.hasArg(ctx, "mirror")) {
            String mir = StringArgumentType.getString(ctx, (String)"mirror");
            try {
                generator.setMirror(Mirror.valueOf((String)mir.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"commands.spawnrb.notmirror", (Object[])new Object[]{mir})).create();
            }
        }
        if (SpawnStructureCommand.hasArg(ctx, "seed")) {
            long seed = LongArgumentType.getLong(ctx, (String)"seed");
            random = RandomSource.m_216335_((long)seed);
        }
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        BlockPos pos = new BlockPos(((CommandSourceStack)ctx.getSource()).m_81371_().f_82479_, ((CommandSourceStack)ctx.getSource()).m_81371_().f_82480_, ((CommandSourceStack)ctx.getSource()).m_81371_().f_82481_);
        generator.generate(level, random, pos);
        return 1;
    }
}

