/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.datagen;

import net.minecraft.core.Registry;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.datagen.ModBlockFamilies;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;

public class JRBlockstateProvider
extends BlockStateProvider {
    protected static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");

    public JRBlockstateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "jurassicreborn", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)ModBlocks.AMBER_ORE.get());
        this.simpleBlock((Block)ModBlocks.AMBER_BLOCK.get());
        ModBlockFamilies.getAllFamilies().forEach(family -> {
            WallBlock wall;
            FenceGateBlock gate;
            FenceBlock fence;
            PressurePlateBlock plate;
            ButtonBlock button;
            SlabBlock slabBlock;
            StairBlock stairBlock;
            DoorBlock door;
            TrapDoorBlock trapdoor;
            Block baseBlock = family.m_175951_();
            this.simpleBlock(baseBlock);
            ResourceLocation location = Registry.f_122824_.m_7981_((Object)baseBlock);
            ResourceLocation baseTexture = this.modLoc("block/" + location.m_135815_());
            Block sign = family.m_175952_(BlockFamily.Variant.SIGN);
            Block wallSign = family.m_175952_(BlockFamily.Variant.WALL_SIGN);
            if (sign != null && wallSign != null) {
                this.signBlock((StandingSignBlock)sign, (WallSignBlock)wallSign, baseTexture);
            }
            if ((trapdoor = (TrapDoorBlock)family.m_175952_(BlockFamily.Variant.TRAPDOOR)) != null) {
                ResourceLocation trapLoc = Registry.f_122824_.m_7981_((Object)trapdoor);
                this.trapdoorBlock(trapdoor, this.modLoc("block/" + trapLoc.m_135815_()), false);
            }
            if ((door = (DoorBlock)family.m_175952_(BlockFamily.Variant.DOOR)) != null) {
                this.simpleDoorBlock(door);
            }
            if ((stairBlock = (StairBlock)family.m_175952_(BlockFamily.Variant.STAIRS)) != null) {
                this.stairsBlock(stairBlock, baseTexture);
            }
            if ((slabBlock = (SlabBlock)family.m_175952_(BlockFamily.Variant.SLAB)) != null) {
                this.slabBlock(slabBlock, baseTexture, baseTexture);
            }
            if ((button = (ButtonBlock)family.m_175952_(BlockFamily.Variant.BUTTON)) != null) {
                this.buttonBlock(button, baseTexture);
            }
            if ((plate = (PressurePlateBlock)family.m_175952_(BlockFamily.Variant.PRESSURE_PLATE)) != null) {
                this.pressurePlateBlock(plate, baseTexture);
            }
            if ((fence = (FenceBlock)family.m_175952_(BlockFamily.Variant.FENCE)) != null) {
                this.fenceBlock(fence, baseTexture);
            }
            if ((gate = (FenceGateBlock)family.m_175952_(BlockFamily.Variant.FENCE_GATE)) != null) {
                this.fenceGateBlock(gate, baseTexture);
            }
            if ((wall = (WallBlock)family.m_175952_(BlockFamily.Variant.WALL)) != null) {
                this.wallBlock(wall, baseTexture);
            }
        });
        this.logBlock((RotatedPillarBlock)WoodBlocks.ARAUCARIA_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.CALAMITES_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.GINKGO_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.MAGNOLIA_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.PHOENIX_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.PSARONIUS_LOG.get());
        this.woodBlock((RotatedPillarBlock)WoodBlocks.ARAUCARIA_WOOD.get(), "araucaria");
        this.woodBlock((RotatedPillarBlock)WoodBlocks.CALAMITES_WOOD.get(), "calamites");
        this.woodBlock((RotatedPillarBlock)WoodBlocks.GINKGO_WOOD.get(), "ginkgo");
        this.woodBlock((RotatedPillarBlock)WoodBlocks.MAGNOLIA_WOOD.get(), "magnolia");
        this.woodBlock((RotatedPillarBlock)WoodBlocks.PHOENIX_WOOD.get(), "phoenix");
        this.woodBlock((RotatedPillarBlock)WoodBlocks.PSARONIUS_WOOD.get(), "psaronius");
        this.logBlock((RotatedPillarBlock)WoodBlocks.PETRIFIED_ARAUCARIA_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.PETRIFIED_CALAMITES_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.PETRIFIED_GINKGO_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.PETRIFIED_MAGNOLIA_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.PETRIFIED_PHOENIX_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.PETRIFIED_PSARONIUS_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_ARAUCARIA_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_CALAMITES_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_GINKGO_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_MAGNOLIA_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_PHOENIX_LOG.get());
        this.logBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_PSARONIUS_LOG.get());
        this.woodBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_ARAUCARIA_WOOD.get(), "araucaria", true);
        this.woodBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_CALAMITES_WOOD.get(), "calamites", true);
        this.woodBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_GINKGO_WOOD.get(), "ginkgo", true);
        this.woodBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_MAGNOLIA_WOOD.get(), "magnolia", true);
        this.woodBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_PHOENIX_WOOD.get(), "phoenix", true);
        this.woodBlock((RotatedPillarBlock)WoodBlocks.STRIPPED_PSARONIUS_WOOD.get(), "psaronius", true);
        this.sapling((SaplingBlock)ModBlocks.ARAUCARIA_SAPLING.get());
        this.sapling((SaplingBlock)ModBlocks.CALAMITES_SAPLING.get());
        this.sapling((SaplingBlock)ModBlocks.GINKGO_SAPLING.get());
        this.sapling((SaplingBlock)ModBlocks.MAGNOLIA_SAPLING.get());
        this.sapling((SaplingBlock)ModBlocks.PHOENIX_SAPLING.get());
        this.sapling((SaplingBlock)ModBlocks.PSARONIUS_SAPLING.get());
        this.ancientLeavesBlock((Block)WoodBlocks.ARAUCARIA_LEAVES.get());
        this.ancientLeavesBlock((Block)WoodBlocks.CALAMITES_LEAVES.get());
        this.ancientLeavesBlock((Block)WoodBlocks.GINKGO_LEAVES.get());
        this.ancientLeavesBlock((Block)WoodBlocks.MAGNOLIA_LEAVES.get());
        this.ancientLeavesBlock((Block)WoodBlocks.PHOENIX_LEAVES.get());
        this.ancientLeavesBlock((Block)WoodBlocks.PSARONIUS_LEAVES.get());
        for (Dinosaur dinosaur : Dinosaur.DINOS) {
            Block fossil;
            if (dinosaur == Dinosaur.EMPTY || (fossil = ModBlocks.getEncasedBlockFor(dinosaur)) == null) continue;
            ResourceLocation fossilName = Registry.f_122824_.m_7981_((Object)fossil);
            this.simpleBlock(fossil, (ModelFile)this.models().cubeAll(fossilName.m_135815_(), this.modLoc("block/encased_fossil")));
        }
        this.simpleDoorBlock((DoorBlock)ModBlocks.REINFORCED_DOOR.get());
        this.simpleDoorBlock((DoorBlock)ModBlocks.SECURITY_DOOR.get());
    }

    public void simpleDoorBlock(DoorBlock door) {
        ResourceLocation doorLoc = Registry.f_122824_.m_7981_((Object)door);
        ResourceLocation top = this.modLoc("block/" + doorLoc.m_135815_() + "_top");
        ResourceLocation bottom = this.modLoc("block/" + doorLoc.m_135815_() + "_bottom");
        this.doorBlock(door, bottom, top);
    }

    public void ancientLeavesBlock(Block block) {
        String name = this.name(block);
        ResourceLocation texture = this.modLoc("block/" + name);
        ModelBuilder file = ((BlockModelBuilder)this.models().withExistingParent(name, "block/leaves")).texture("all", texture);
        this.simpleBlock(block, (ModelFile)file);
    }

    public void sapling(SaplingBlock block) {
        this.simpleBlock((Block)block, this.cross((Block)block));
    }

    public ModelFile cross(Block block) {
        return this.models().cross(this.name(block), this.blockTexture(block));
    }

    public void woodBlock(RotatedPillarBlock block, String base) {
        this.woodBlock(block, base, false);
    }

    public void woodBlock(RotatedPillarBlock block, String base, boolean stripped) {
        ResourceLocation texture = this.modLoc("block/" + (stripped ? "stripped_" : "") + base + "_log");
        ModelBuilder modelFile = this.models().cubeColumn(this.name((Block)block), texture, texture);
        this.axisBlock(block, (ModelFile)modelFile, (ModelFile)modelFile);
    }

    protected String name(Block block) {
        return Registry.f_122824_.m_7981_((Object)block).m_135815_();
    }
}

