/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.DinosaurEggItem;

public class DinosaurEggEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private DinosaurEntity entity;
    private double motionX;
    private double motionY;
    private double motionZ;
    private UUID parent;
    private Dinosaur dinosaur;
    private int hatchTime = this.random(5000, 6000);

    public DinosaurEggEntity(EntityType<? extends DinosaurEggEntity> type, Level world, DinosaurEntity entity, DinosaurEntity parent) {
        this(type, world);
        this.entity = entity;
        this.dinosaur = entity.getDinosaur();
        this.parent = parent.m_20148_();
    }

    public DinosaurEggEntity(EntityType<? extends DinosaurEggEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.dinosaur == null) {
            Optional parentEntity;
            Optional<Object> optional = this.f_19853_.f_46443_ ? Optional.empty() : (parentEntity = ((ServerLevel)this.f_19853_).m_8791_(this.parent) == null ? Optional.empty() : Optional.of(((ServerLevel)this.f_19853_).m_8791_(this.parent)));
            if (parentEntity.isPresent() && parentEntity.get() instanceof DinosaurEntity) {
                this.dinosaur = ((DinosaurEntity)parentEntity.get()).getDinosaur();
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (this.entity == null) {
                this.m_6074_();
            }
            --this.hatchTime;
            if (this.hatchTime <= 0) {
                this.hatch();
            }
        }
        Vec3 motion = this.m_20184_();
        if (!this.m_20068_()) {
            motion = motion.m_82520_(0.0, -0.04, 0.0);
        }
        this.m_6478_(MoverType.SELF, motion);
        float drag = this.f_19861_ ? 0.7f : 0.98f;
        this.m_20334_(motion.f_82479_ * (double)drag, motion.f_82480_ * (double)0.98f, motion.f_82481_ * (double)drag);
    }

    public boolean m_5829_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            this.dropEggItem();
            this.m_6074_();
        }
        return true;
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (this.entity != null && !this.f_19853_.f_46443_) {
            this.dropEggItem();
            this.m_6074_();
        }
        return super.m_6096_(pPlayer, pHand);
    }

    public void hatch() {
        if (this.dinosaur != null && this.entity != null) {
            try {
                this.entity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)this.entity);
                this.entity.m_8032_();
                this.m_6074_();
                if (this.dinosaur == null) {
                    Optional parentEntity;
                    Optional<Object> optional = this.f_19853_.f_46443_ ? Optional.empty() : (parentEntity = ((ServerLevel)this.f_19853_).m_8791_(this.parent) == null ? Optional.empty() : Optional.of(((ServerLevel)this.f_19853_).m_8791_(this.parent)));
                    if (parentEntity.isPresent() && parentEntity.get() instanceof DinosaurEntity && this.dinosaur.shouldDefendOffspring() && ((DinosaurEntity)parentEntity.get()).family != null) {
                        ((DinosaurEntity)parentEntity.get()).family.addChild(this.entity.m_20148_());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int random(int min, int max) {
        int range = max - min + 1;
        return (int)(Math.random() * (double)range) + min;
    }

    protected void m_7378_(CompoundTag compound) {
        Entity loaded;
        this.hatchTime = compound.m_128451_("HatchTime");
        CompoundTag entityTag = compound.m_128469_("Hatchling");
        if (!entityTag.m_128456_() && (loaded = EntityType.m_20645_((CompoundTag)entityTag, (Level)this.f_19853_, e -> e)) instanceof DinosaurEntity) {
            DinosaurEntity dino;
            this.entity = dino = (DinosaurEntity)loaded;
            this.dinosaur = dino.getDinosaur();
        }
        this.parent = compound.m_128342_("Parent");
        if (this.dinosaur == null && compound.m_128441_("DinosaurID")) {
            this.dinosaur = DinosaurHandler.getById(compound.m_128451_("DinosaurID"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("HatchTime", this.hatchTime);
        if (this.entity != null) {
            compound.m_128365_("Hatchling", (Tag)this.entity.serializeNBT());
        }
        compound.m_128362_("Parent", this.parent);
        if (this.dinosaur != null) {
            compound.m_128405_("DinosaurID", DinosaurHandler.getId(this.dinosaur));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        int id = DinosaurHandler.getId(this.dinosaur != null ? this.dinosaur : Dinosaur.EMPTY);
        buffer.writeInt(id);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.dinosaur = DinosaurHandler.getById(additionalData.readInt());
    }

    @Nullable
    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    private void dropEggItem() {
        if (this.dinosaur == null || this.entity == null) {
            return;
        }
        RegistryObject<DinosaurEggItem> eggItem = ModItems.dinoEggs.get(this.dinosaur);
        if (eggItem == null) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)eggItem.get());
        CompoundTag tag = stack.m_41784_();
        DinoDNA dna = new DinoDNA(this.entity.getDinosaur(), this.entity.getDNAQuality(), this.entity.getGenetics());
        dna.writeToNBT(tag);
        stack.m_41751_(tag);
        this.m_19983_(stack);
    }
}

