/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.LegSolverQuadruped;

public class BrachiosaurusEntity
extends DinosaurEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(BrachiosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int stepCount = 0;
    public LegSolverQuadruped legSolver;

    public BrachiosaurusEntity(EntityType<BrachiosaurusEntity> type, Level world) {
        super(world, type, DinosaurHandler.BRACHIOSAURUS);
        this.addTask(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.setVariant(this.m_217043_().m_188503_(4));
    }

    @Override
    protected LegSolverQuadruped createLegSolver() {
        this.legSolver = new LegSolverQuadruped(2.5f, 2.0f, 1.0f, 1.0f);
        return this.legSolver;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19861_ && !this.m_20069_()) {
            if (this.f_20902_ > 0.0f && (this.m_20185_() - this.f_19854_ > 0.0 || this.m_20189_() - this.f_19856_ > 0.0) && this.stepCount <= 0) {
                this.m_5496_(SoundHandler.STOMP, (float)this.interpolate(0.1f, 1.0), this.m_6100_());
                this.stepCount = 65;
            }
            this.stepCount = (int)((double)this.stepCount - (double)this.f_20902_ * 9.5);
        }
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.BRACHIOSAURUS_LIVING;
            }
            case CALLING: {
                return SoundHandler.BRACHIOSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.BRACHIOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.BRACHIOSAURUS_HURT;
            }
            case WALKING: {
                return SoundHandler.STOMP;
            }
        }
        return null;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("jp");
            }
            case 1: {
                return this.texture("jp3");
            }
            case 2: {
                return this.texture("blue");
            }
            case 3: 
        }
        return this.texture("jwfk");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("jurassicreborn", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("jurassicreborn", texture + "_female_adult_" + variant + ".png");
    }
}

