/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import java.util.ArrayList;
import java.util.List;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DinosaurStatus {
    CARNIVOROUS{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getDinosaur().getDiet().canEat(entity, FoodType.MEAT);
        }
    }
    ,
    PISCIVOROUS{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getDinosaur().getDiet().canEat(entity, FoodType.FISH);
        }
    }
    ,
    HERBIVOROUS{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getDinosaur().getDiet().canEat(entity, FoodType.PLANT);
        }
    }
    ,
    INSECTIVOROUS{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getDinosaur().getDiet().canEat(entity, FoodType.INSECT);
        }
    }
    ,
    DIURNAL{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getDinosaur().getSleepTime() == SleepTime.DIURNAL;
        }
    }
    ,
    NOCTURNAL{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getDinosaur().getSleepTime() == SleepTime.NOCTURNAL;
        }
    }
    ,
    CREPUSCULAR{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getDinosaur().getSleepTime() == SleepTime.CREPUSCULAR;
        }
    }
    ,
    TAMED{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getOwner() != null;
        }
    }
    ,
    LOW_HEALTH{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.m_21223_() < entity.m_21233_() / 4.0f || entity.isCarcass();
        }
    }
    ,
    HUNGRY{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.hungry;
        }
    }
    ,
    THIRSTY{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.thirsty;
        }
    }
    ,
    POISONED{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.poisoned;
        }
    }
    ,
    DROWNING{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return !entity.getDinosaur().isMarineCreature() && entity.m_20146_() < 200;
        }
    }
    ,
    SLEEPY{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.shouldSleep();
        }
    }
    ,
    FLOCKING{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.flocking;
        }
    }
    ,
    SCARED{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.scared;
        }
    };


    public static List<DinosaurStatus> getActiveStatuses(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
        ArrayList<DinosaurStatus> statuses = new ArrayList<DinosaurStatus>();
        for (DinosaurStatus status : DinosaurStatus.values()) {
            if (!status.apply(entity, info)) continue;
            statuses.add(status);
        }
        return statuses;
    }

    public abstract boolean apply(DinosaurEntity var1, DinosaurEntity.FieldGuideInfo var2);
}

