/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SegisaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class SegisaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public SegisaurusDinosaur() {
        this.setName("Segisaurus");
        this.setScientificName("Segisaurus halli");
        this.setFamily("Coelophysidae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(SegisaurusEntity.class);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(8604492, 4951989);
        this.setEggColorFemale(0xCEEE99, 7824195);
        this.setHealth(4.0, 14.0);
        this.setStrength(1.0, 7.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setMaximumAge(this.fromDays(30));
        this.setEyeHeight(0.35f, 0.7f);
        this.setSizeX(0.28f, 0.43f);
        this.setSizeY(0.35f, 0.8f);
        this.setStorage(9);
        this.setDiet(Diet.CARNIVORE.get());
        this.setSleepTime(SleepTime.NOCTURNAL);
        this.setBones("skull", "tail_vertebrae", "teeth", "leg_bones", "foot_bones", "neck_vertebrae", "shoulder", "ribcage", "pelvis", "arm_bones", "claw");
        this.setHeadCubeName("head");
        this.setAttackBias(90.0);
        this.setScale(0.45f, 0.13f);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setStorage(12);
        this.setBreeding(false, 0, 6, 20, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", "teeth"}, {"", "", "leg_bones", "arm_bones", "claw"}, {"", "", "foot_bones", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207610_, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

