/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.ai.navigation.MoveUnderwaterEntityAI;

public abstract class SwimmingDinosaurEntity
extends DinosaurEntity {
    public SwimmingDinosaurEntity(Level world, EntityType type, Dinosaur dino) {
        super(world, (EntityType<? extends DinosaurEntity>)type, dino);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21345_.m_25352_(1, (Goal)new MoveUnderwaterEntityAI(this));
        this.f_21344_ = new WaterBoundPathNavigation((Mob)this, world);
    }

    @Override
    public void m_8119_() {
        int air = this.m_20146_();
        super.m_8119_();
        if (this.m_6084_() && !this.m_20069_()) {
            this.m_20301_(--air);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19312_, 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    @Override
    public void m_7023_(Vec3 vec) {
        boolean noInput;
        float strafe = (float)vec.f_82479_;
        float vertical = (float)vec.f_82480_;
        float forward = (float)vec.f_82481_;
        boolean bl = noInput = strafe == 0.0f && vertical == 0.0f && forward == 0.0f;
        if (!this.f_19853_.f_46443_ && this.m_20069_() && !this.isCarcass()) {
            this.m_19920_(0.1f, new Vec3((double)strafe, (double)vertical, (double)forward));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 movement = this.m_20184_().m_82542_(0.7, 0.7, 0.7);
            if (noInput) {
                movement = movement.m_82520_(0.0, -0.005, 0.0);
            }
            this.m_20256_(movement);
        } else {
            super.m_7023_(vec);
        }
    }

    protected void spawnInk() {
        this.m_5496_(SoundEvents.f_12441_, this.m_6121_(), this.m_6100_());
        Vec3 view = this.m_20252_(0.0f);
        double x = view.f_82479_;
        double y = view.f_82480_;
        double z = view.f_82481_;
        for (int i = 0; i < 30; ++i) {
            double dx = this.f_19796_.m_188583_() * 0.02;
            double dy = this.f_19796_.m_188583_() * 0.02;
            double dz = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123765_, this.m_20185_() + x * 0.1 + (this.f_19796_.m_188500_() - 0.5) * 0.6, this.m_20186_() + y * 0.1 + (this.f_19796_.m_188500_() - 0.5) * 0.6, this.m_20189_() + z * 0.1 + (this.f_19796_.m_188500_() - 0.5) * 0.6, dx, dy, dz);
        }
    }

    class SwimmingMoveHelper
    extends MoveControl {
        private final SwimmingDinosaurEntity swimmingEntity;

        public SwimmingMoveHelper() {
            super((Mob)SwimmingDinosaurEntity.this);
            this.swimmingEntity = SwimmingDinosaurEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.swimmingEntity.m_21573_().m_26571_()) {
                double distanceX = this.f_24975_ - this.swimmingEntity.m_20185_();
                double distanceY = this.f_24976_ - this.swimmingEntity.m_20186_();
                double distanceZ = this.f_24977_ - this.swimmingEntity.m_20189_();
                double distance = Math.abs(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                distance = Math.sqrt(distance);
                float f = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.swimmingEntity.m_146922_(this.m_24991_(this.swimmingEntity.m_146908_(), f, 30.0f));
                this.swimmingEntity.m_7910_((float)(this.swimmingEntity.m_21051_(Attributes.f_22279_).m_22135_() * this.f_24978_));
                this.swimmingEntity.m_20256_(this.swimmingEntity.m_20184_().m_82520_(0.0, (double)this.swimmingEntity.m_6113_() * (distanceY /= distance) * 0.05, 0.0));
            } else {
                this.swimmingEntity.m_7910_(0.0f);
            }
        }
    }
}

