/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.vit.jurassicreborn.client.JurassicClient;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DilophosaurusEntity;

public class VenomEntity
extends Projectile {
    public VenomEntity(EntityType<? extends VenomEntity> type, Level level) {
        super(type, level);
    }

    public VenomEntity(EntityType<? extends VenomEntity> type, Level level, LivingEntity owner) {
        this(type, level);
        this.m_5602_((Entity)owner);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 start = this.m_20182_();
        Vec3 motion = this.m_20184_();
        Vec3 end = start.m_82549_(motion);
        BlockHitResult blockHit = this.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        AABB aabb = this.m_20191_().m_82369_(motion).m_82400_(1.0);
        EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)start, (Vec3)end, (AABB)aabb, x$0 -> this.m_5603_((Entity)x$0));
        EntityHitResult chosen = null;
        if (entityHit != null) {
            chosen = entityHit;
        }
        if (blockHit != null && blockHit.m_6662_() != HitResult.Type.MISS && (chosen == null || start.m_82554_(blockHit.m_82450_()) < start.m_82554_(chosen.m_82450_()))) {
            chosen = blockHit;
        }
        if (chosen != null && chosen.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_((HitResult)chosen);
        }
        this.m_6034_(this.m_20185_() + motion.f_82479_, this.m_20186_() + motion.f_82480_, this.m_20189_() + motion.f_82481_);
        if (!this.m_20068_()) {
            this.m_20334_(motion.f_82479_, motion.f_82480_ - 0.05, motion.f_82481_);
        }
        if (this.f_19853_.f_46443_) {
            JurassicClient.spawnVenomParticles(this);
        }
    }

    protected void m_6532_(HitResult hit) {
        super.m_6532_(hit);
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        Entity owner = this.m_37282_();
        Entity victim = hit.m_82443_();
        if (victim == owner) {
            return;
        }
        if (owner instanceof DilophosaurusEntity) {
            DilophosaurusEntity dilo = (DilophosaurusEntity)owner;
            if (victim instanceof DilophosaurusEntity && victim != dilo.m_5448_()) {
                return;
            }
        }
        if (victim instanceof LivingEntity) {
            LivingEntity o;
            LivingEntity living = (LivingEntity)victim;
            DamageSource src = DamageSource.m_19340_((Entity)this, owner instanceof LivingEntity ? (o = (LivingEntity)owner) : null);
            living.m_6469_(src, 4.0f);
            living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300, 1, false, false));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 1, false, false));
        }
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void spawnParticles() {
        JurassicClient.spawnVenomParticles(this);
    }
}

