/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DilophosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class DilophosaurusSpitGoal
extends Goal {
    private final DilophosaurusEntity dilo;
    private LivingEntity target;
    private final double speed;
    private final int attackInterval;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistanceSq;
    private int rangedAttackTime = -1;
    private int seeTime = 0;
    private int animationTimer = -1;
    private int stuckCheckTime = 0;
    private double lastStuckCheckX;
    private double lastStuckCheckY;
    private double lastStuckCheckZ;

    public DilophosaurusSpitGoal(DilophosaurusEntity dilo, double speed, int attackInterval, int maxAttackTime, float maxAttackDistance) {
        this.dilo = dilo;
        this.speed = speed;
        this.attackInterval = attackInterval;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistance;
        this.maxAttackDistanceSq = maxAttackDistance * maxAttackDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public DilophosaurusSpitGoal(DilophosaurusEntity dilo, double speed, int maxAttackTime, float maxAttackDistance) {
        this(dilo, speed, maxAttackTime, maxAttackTime, maxAttackDistance);
    }

    public boolean m_8036_() {
        DinosaurEntity dino;
        LivingEntity candidate = this.dilo.m_5448_();
        if (candidate == null) {
            return false;
        }
        if (candidate.m_21224_()) {
            return false;
        }
        if (candidate instanceof DinosaurEntity && (dino = (DinosaurEntity)candidate).isCarcass()) {
            return false;
        }
        if (candidate.m_21223_() < candidate.m_21233_() * 0.9f && candidate.m_21023_(MobEffects.f_19610_)) {
            return false;
        }
        if (this.dilo.m_20069_()) {
            return false;
        }
        this.target = candidate;
        return true;
    }

    public boolean m_8045_() {
        if (!this.m_8036_()) {
            return !this.dilo.m_21573_().m_26571_();
        }
        return true;
    }

    public void m_8056_() {
        this.rangedAttackTime = -1;
        this.seeTime = 0;
        this.animationTimer = -1;
        this.stuckCheckTime = 0;
        this.lastStuckCheckX = this.dilo.m_20185_();
        this.lastStuckCheckY = this.dilo.m_20186_();
        this.lastStuckCheckZ = this.dilo.m_20189_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
        this.animationTimer = -1;
        this.stuckCheckTime = 0;
    }

    public void m_8037_() {
        boolean shouldHoldPosition;
        if (this.target == null) {
            return;
        }
        double distSq = this.dilo.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean canSee = this.dilo.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        double dx = this.target.m_20185_() - this.dilo.m_20185_();
        double dz = this.target.m_20189_() - this.dilo.m_20189_();
        double horizDistSq = dx * dx + dz * dz;
        double verticalGap = Math.abs(this.target.m_20186_() - this.dilo.m_20186_());
        boolean bl = shouldHoldPosition = distSq <= (double)this.maxAttackDistanceSq && this.seeTime >= 10 && horizDistSq <= (double)(this.attackRadius * this.attackRadius * 0.75f) && verticalGap <= (double)(this.dilo.getStepHeight() + 0.75f);
        if (shouldHoldPosition) {
            this.dilo.m_21573_().m_26573_();
        } else {
            this.dilo.m_21573_().m_5624_((Entity)this.target, this.speed);
        }
        if (!shouldHoldPosition) {
            double deltaSq = this.dilo.m_20275_(this.lastStuckCheckX, this.lastStuckCheckY, this.lastStuckCheckZ);
            if (deltaSq < 0.0125) {
                if (++this.stuckCheckTime > 12) {
                    this.dilo.m_21573_().m_26569_();
                    if (this.dilo.m_20096_()) {
                        this.dilo.m_21569_().m_24901_();
                    }
                    this.stuckCheckTime = 0;
                }
            } else {
                this.stuckCheckTime = 0;
                this.lastStuckCheckX = this.dilo.m_20185_();
                this.lastStuckCheckY = this.dilo.m_20186_();
                this.lastStuckCheckZ = this.dilo.m_20189_();
            }
        } else {
            this.stuckCheckTime = 0;
            this.lastStuckCheckX = this.dilo.m_20185_();
            this.lastStuckCheckY = this.dilo.m_20186_();
            this.lastStuckCheckZ = this.dilo.m_20189_();
        }
        this.dilo.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (distSq > (double)this.maxAttackDistanceSq || !canSee) {
                this.resetCooldownByDistance(distSq);
                return;
            }
            if (SoundHandler.DILOPHOSAURUS_SPIT != null) {
                this.dilo.m_5496_(SoundHandler.DILOPHOSAURUS_SPIT, this.dilo.m_6121_(), this.dilo.m_6100_());
            }
            this.dilo.setAnimation(EntityAnimation.DILOPHOSAURUS_SPIT.get());
            this.animationTimer = 20;
        } else if (this.rangedAttackTime < 0) {
            this.resetCooldownByDistance(distSq);
        }
        if (this.animationTimer >= 0) {
            --this.animationTimer;
            if (this.animationTimer == 0) {
                boolean canSeeNow = this.dilo.m_21574_().m_148306_((Entity)this.target);
                if (distSq <= (double)this.maxAttackDistanceSq && canSeeNow) {
                    float scaled = Mth.m_14116_((float)((float)distSq)) / this.attackRadius;
                    scaled = Mth.m_14036_((float)scaled, (float)0.1f, (float)1.0f);
                    this.dilo.m_6504_(this.target, scaled);
                }
                this.resetCooldownByDistance(distSq);
            }
        }
    }

    private void resetCooldownByDistance(double distSq) {
        int cd;
        float scaled = Mth.m_14116_((float)((float)distSq)) / this.attackRadius;
        this.rangedAttackTime = cd = Mth.m_14143_((float)(scaled * (float)(this.maxRangedAttackTime - this.attackInterval) + (float)this.attackInterval));
    }
}

