/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.metabolism;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlock;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlockEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.FlyingDinosaurEntity;
import net.vit.jurassicreborn.common.util.GameRuleHandler;

public class FeederEntityAI
extends Goal {
    private final DinosaurEntity dino;
    private Path path;
    private BlockPos feederPos;
    private Vec3 feederTarget;
    private int ticksTrying;

    public FeederEntityAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        boolean canDirectMove;
        Path p;
        int intervalMask;
        if (this.dino == null || this.dino.m_213877_() || this.dino.isCarcass() || this.dino.isMovementBlocked()) {
            return false;
        }
        if (!this.dino.f_19853_.m_46469_().m_46207_(GameRuleHandler.DINO_METABOLISM)) {
            return false;
        }
        int n = intervalMask = this.dino.isMarineCreature() ? 7 : 15;
        if ((this.dino.f_19797_ & intervalMask) != 0) {
            return false;
        }
        if (!this.dino.getMetabolism().isHungry()) {
            return false;
        }
        BlockPos found = this.dino.getClosestFeeder();
        if (found == null) {
            return false;
        }
        Level level = this.dino.f_19853_;
        if (level == null || !level.m_46805_(found)) {
            return false;
        }
        BlockState state = level.m_8055_(found);
        if (state.m_60734_() != ModBlocks.FEEDER.get()) {
            return false;
        }
        Vec3 target = this.computeTarget(found, state);
        try {
            p = this.dino.m_21573_().m_7864_(new BlockPos(target.f_82479_, target.f_82480_, target.f_82481_), 0);
        }
        catch (Throwable t) {
            p = null;
        }
        boolean bl = canDirectMove = this.dino.isMarineCreature() || this.dino instanceof FlyingDinosaurEntity;
        if (p == null && !canDirectMove) {
            return false;
        }
        this.feederPos = found.m_7949_();
        this.path = p;
        this.feederTarget = target;
        this.ticksTrying = 0;
        return true;
    }

    public void m_8056_() {
        if (this.path != null) {
            this.dino.m_21573_().m_26536_(this.path, 1.0);
        } else if (this.feederTarget != null) {
            if (this.shouldTakeOffForTarget()) {
                ((FlyingDinosaurEntity)this.dino).startTakeOff();
            }
            this.dino.m_21566_().m_6849_(this.feederTarget.f_82479_, this.feederTarget.f_82480_, this.feederTarget.f_82481_, 1.0);
        }
    }

    public boolean m_8045_() {
        boolean directMove;
        if (this.dino == null || this.feederPos == null) {
            return false;
        }
        if (this.dino.isCarcass() || this.dino.isMovementBlocked()) {
            return false;
        }
        if (!this.dino.getMetabolism().isHungry()) {
            return false;
        }
        BlockState state = this.dino.f_19853_.m_8055_(this.feederPos);
        if (state.m_60734_() != ModBlocks.FEEDER.get()) {
            return false;
        }
        this.feederTarget = this.computeTarget(this.feederPos, state);
        boolean bl = directMove = this.path == null && (this.dino.isMarineCreature() || this.dino instanceof FlyingDinosaurEntity);
        if (directMove && this.feederTarget != null) {
            double reach;
            double dist = this.dino.m_20182_().m_82554_(this.feederTarget);
            return dist > (reach = Math.max(1.0, (double)this.dino.m_20205_() * 2.0)) && this.ticksTrying < 200;
        }
        return !this.dino.m_21573_().m_26571_() && this.ticksTrying < 200;
    }

    public void m_8037_() {
        boolean wantsDirectMove;
        Path retry;
        if (this.feederPos == null) {
            return;
        }
        BlockState state = this.dino.f_19853_.m_8055_(this.feederPos);
        if (state.m_60734_() != ModBlocks.FEEDER.get()) {
            this.m_8041_();
            return;
        }
        this.feederTarget = this.computeTarget(this.feederPos, state);
        if (++this.ticksTrying % 40 == 0 && !this.dino.m_21573_().m_26572_() && (retry = this.dino.m_21573_().m_7864_(new BlockPos(this.feederTarget.f_82479_, this.feederTarget.f_82480_, this.feederTarget.f_82481_), 0)) != null) {
            this.path = retry;
            this.dino.m_21573_().m_26536_(retry, 1.0);
        }
        boolean bl = wantsDirectMove = this.path == null && (this.dino.isMarineCreature() || this.dino instanceof FlyingDinosaurEntity);
        if (wantsDirectMove && this.feederTarget != null) {
            if (this.shouldTakeOffForTarget()) {
                ((FlyingDinosaurEntity)this.dino).startTakeOff();
            }
            this.dino.m_21566_().m_6849_(this.feederTarget.f_82479_, this.feederTarget.f_82480_, this.feederTarget.f_82481_, 1.0);
        }
        if (!this.dino.f_19853_.f_46443_) {
            double reach;
            Vec3 target = this.feederTarget != null ? this.feederTarget : Vec3.m_82512_((Vec3i)this.feederPos);
            double dist = this.dino.m_20182_().m_82554_(target);
            if (dist <= (reach = Math.max(1.0, (double)this.dino.m_20205_() * 2.0))) {
                BlockEntity be = this.dino.f_19853_.m_7702_(this.feederPos);
                if (be instanceof FeederBlockEntity) {
                    FeederBlockEntity feeder = (FeederBlockEntity)be;
                    feeder.setOpen(true);
                    feeder.setFeeding(this.dino);
                }
                this.m_8041_();
            }
        }
    }

    public void m_8041_() {
        if (this.dino != null) {
            this.dino.m_21573_().m_26573_();
        }
        this.path = null;
        this.feederPos = null;
        this.feederTarget = null;
        this.ticksTrying = 0;
    }

    private Vec3 computeTarget(BlockPos pos, BlockState state) {
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        if (!state.m_61138_((Property)FeederBlock.FACING)) {
            return center;
        }
        Direction facing = (Direction)state.m_61143_((Property)FeederBlock.FACING);
        double forward = 0.6;
        double vertical = 0.0;
        if (facing.m_122434_().m_122479_()) {
            vertical = this.dino.isMarineCreature() ? 0.05 : 0.3;
        } else if (facing == Direction.UP) {
            vertical = 0.6;
        } else if (facing == Direction.DOWN) {
            vertical = -0.3;
        }
        return center.m_82520_((double)facing.m_122429_() * forward, (double)facing.m_122430_() * forward + vertical, (double)facing.m_122431_() * forward);
    }

    private boolean shouldTakeOffForTarget() {
        if (!(this.dino instanceof FlyingDinosaurEntity) || this.feederTarget == null) {
            return false;
        }
        boolean needsAltitude = this.feederTarget.f_82480_ - this.dino.m_20186_() > 0.75;
        return needsAltitude || this.path == null;
    }
}

