/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.vehicle.boat.JurassicBoat;
import net.vit.jurassicreborn.common.entities.vehicle.boat.JurassicChestBoat;
import net.vit.jurassicreborn.common.entities.vehicle.boat.ModBoatType;

public class JurassicBoatItem
extends Item {
    private final boolean hasChest;
    private final ModBoatType type;

    public JurassicBoatItem(boolean hasChest, ModBoatType type, Item.Properties properties) {
        super(properties);
        this.hasChest = hasChest;
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        BlockHitResult hitResult = JurassicBoatItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        Vec3 viewVector = player.m_20252_(1.0f);
        double reach = 5.0;
        List entities = level.m_6249_((Entity)player, player.m_20191_().m_82369_(viewVector.m_82490_(reach)).m_82400_(1.0), entity -> !entity.m_5833_() && entity.m_6087_());
        Vec3 eyePosition = player.m_20299_(1.0f);
        for (Entity entity2 : entities) {
            AABB aabb = entity2.m_20191_().m_82400_((double)entity2.m_6143_());
            if (!aabb.m_82390_(eyePosition)) continue;
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        Boat boat = this.createBoat(level, (HitResult)hitResult);
        boat.m_146922_(player.m_146908_());
        boat.m_146926_(0.0f);
        boat.f_19859_ = boat.m_146908_();
        boat.f_19860_ = boat.m_146909_();
        if (!level.m_45756_((Entity)boat, boat.m_20191_().m_82400_(-0.1))) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (!level.f_46443_) {
            level.m_7967_((Entity)boat);
            level.m_220400_((Entity)player, GameEvent.f_157810_, hitResult.m_82450_());
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            level.m_6263_(null, boat.m_20185_(), boat.m_20186_(), boat.m_20189_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    private Boat createBoat(Level level, HitResult hitResult) {
        double x = hitResult.m_82450_().f_82479_;
        double y = hitResult.m_82450_().f_82480_;
        double z = hitResult.m_82450_().f_82481_;
        if (this.hasChest) {
            JurassicChestBoat boat = new JurassicChestBoat(level, x, y, z);
            boat.setVariant(this.type);
            return boat;
        }
        JurassicBoat boat = new JurassicBoat(level, x, y, z);
        boat.setVariant(this.type);
        return boat;
    }
}

