/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.misc.ActionFigureItem;
import org.jetbrains.annotations.NotNull;

public class TabHandler {
    public static ArrayList<CreativeModeTab> tabs = new ArrayList();
    public static HashMap<String, ArrayDeque<Item>> SCROLLING_TAB_ITEMS = new HashMap();
    public static final CreativeModeTab ITEMS = TabHandler.makeTab("jurassicreborn.items", List.of(ModItems.APHID_AMBER, ModItems.MOSQUITO_AMBER));
    public static final CreativeModeTab BLOCKS = TabHandler.makeSimpleTab("jurassicreborn.blocks", ModItems.GYPSUM_BRICKS);
    public static final CreativeModeTab DECORATIONS = TabHandler.makeTab("jurassicreborn.decorations", new ArrayList<RegistryObject<ActionFigureItem>>(ModItems.ACTION_FIGURES.values()));
    public static final CreativeModeTab DNA = TabHandler.makeSimpleTab("jurassicreborn.dna", (Supplier)ModItems.DINOSAUR_DNA.get(DinosaurHandler.MAMENCHISAURUS));
    public static final CreativeModeTab SPAWN_EGGS = TabHandler.makeSimpleTab("jurassicreborn.spawn_eggs", ModItems.DINO_SPAWN_EGG);
    public static final CreativeModeTab FOSSILS = TabHandler.makeSimpleTab("jurassicreborn.fossils", ModItems.FAUNA_FOSSIL_BLOCK);
    public static final CreativeModeTab FOODS = TabHandler.makeTab("jurassicreborn.foods", ModItems.ALL_MEATS);
    public static final CreativeModeTab PLANTS = TabHandler.makeSimpleTab("jurassicreborn.plants", ModItems.PLANT_CALLUS);

    public static <I extends Item> CreativeModeTab makeSimpleTab(String name, final Supplier<I> icon) {
        return new CreativeModeTab(name){

            public ItemStack m_6976_() {
                return ((Item)icon.get()).m_7968_();
            }
        };
    }

    public static <I extends Item> CreativeModeTab makeTab(final String name, final List<Supplier<? extends I>> icon) {
        CreativeModeTab tab = new CreativeModeTab(name){
            private long prev;
            {
                super(label);
                this.prev = System.currentTimeMillis();
            }

            public ItemStack m_40787_() {
                if (!SCROLLING_TAB_ITEMS.containsKey(name)) {
                    return super.m_40787_();
                }
                if (System.currentTimeMillis() >= this.prev + 5000L) {
                    Item i = SCROLLING_TAB_ITEMS.get(name).poll();
                    SCROLLING_TAB_ITEMS.get(name).addLast(i);
                    this.prev = System.currentTimeMillis();
                }
                return SCROLLING_TAB_ITEMS.get(name).peek().m_7968_();
            }

            @NotNull
            public ItemStack m_6976_() {
                if (icon == null) {
                    return ItemStack.f_41583_;
                }
                if (icon.size() != 1) {
                    ArrayDeque<Item> itemsQueue = new ArrayDeque<Item>();
                    for (Supplier itemSup : icon) {
                        itemsQueue.push((Item)itemSup.get());
                    }
                    SCROLLING_TAB_ITEMS.put(name, itemsQueue);
                }
                return ((Item)((Supplier)icon.get(0)).get()).m_7968_();
            }
        };
        tabs.add(tab);
        return tab;
    }

    public static CreativeModeTab makeTab(CreativeModeTab tab) {
        tabs.add(tab);
        return tab;
    }
}

