/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.genetics;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.genetics.PlantDNA;
import net.vit.jurassicreborn.common.genetics.StorageTypeRegistry;
import org.jetbrains.annotations.Nullable;

public class DNAContainerItem
extends Item {
    protected boolean appendTooltip = true;

    public DNAContainerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public int getContainerId(ItemStack stack) {
        return 0;
    }

    public static int getDNAQuality(boolean creative, ItemStack stack) {
        int quality = creative ? 100 : 0;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("DNA")) {
            if (nbt.m_128469_("DNA").m_128461_("StorageId").equals("DinoDNA")) {
                DinoDNA dna = DinoDNA.fromStack(stack);
                if (dna == null) {
                    return 0;
                }
                quality = dna.getDNAQuality();
            } else if (nbt.m_128469_("DNA").m_128461_("StorageId").equals("PlantDNA")) {
                PlantDNA dna = PlantDNA.fromStack(stack);
                if (dna == null) {
                    return 0;
                }
                quality = dna.getDNAQuality();
            }
        } else {
            return quality;
        }
        stack.m_41751_(nbt);
        return quality;
    }

    public static String getGeneticCode(RandomSource player, ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        String genetics = GeneticsHelper.randomGenetics(player);
        if (nbt.m_128441_("DNA")) {
            if (nbt.m_128469_("DNA").m_128461_("StorageId").equals("DinoDNA")) {
                DinoDNA dna = DinoDNA.readFromNBT(nbt);
                if (dna == null) {
                    return genetics;
                }
                genetics = dna.getGenetics();
            }
        } else {
            return genetics;
        }
        stack.m_41751_(nbt);
        return genetics;
    }

    public static boolean hasGeneticCode(ItemStack stack) {
        return stack.m_41784_().m_128441_("Genetics");
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> lore, TooltipFlag pIsAdvanced) {
        if (!this.appendTooltip) {
            return;
        }
        CompoundTag tag = pStack.m_41784_();
        if (!tag.m_128441_("isCreative")) {
            if (tag.m_128441_("DNA")) {
                StorageTypeRegistry.getStorageType(tag.m_128469_("DNA").m_128461_("StorageId")).load(tag).addInformation(pStack, lore);
            } else {
                lore.add((Component)Component.m_237115_((String)"cage.empty").m_130940_(ChatFormatting.DARK_RED));
            }
        } else {
            boolean fromCreativeMenu = false;
            if (pStack.m_41784_().m_128441_("isCreative")) {
                fromCreativeMenu = pStack.m_41784_().m_128471_("isCreative");
            }
            int quality = DNAContainerItem.getDNAQuality(fromCreativeMenu, pStack);
            RandomSource rand = RandomSource.m_216327_();
            if (pLevel != null) {
                rand = pLevel.m_213780_();
            }
            ChatFormatting colour = quality > 75 ? ChatFormatting.GREEN : (quality > 50 ? ChatFormatting.YELLOW : (quality > 25 ? ChatFormatting.GOLD : ChatFormatting.RED));
            lore.add((Component)Component.m_237113_((String)Component.m_237115_((String)"lore.dna_quality").getString().formatted(Integer.toString(quality), "%")).m_130940_(colour));
            if (DNAContainerItem.hasGeneticCode(pStack)) {
                lore.add((Component)Component.m_237113_((String)Component.m_237115_((String)"lore.genetic_code").getString().formatted(DNAContainerItem.getGeneticCode(rand, pStack))).m_130940_(ChatFormatting.BLUE));
            }
        }
    }
}

