/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.misc;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.items.TabHandler;
import net.vit.jurassicreborn.common.util.LangUtil;

public class DinosaurSpawnEggItem
extends Item {
    private static final String TAG_DINO = "DinoID";
    private static final String TAG_GENDER = "GenderMode";

    public DinosaurSpawnEggItem() {
        super(new Item.Properties().m_41491_(TabHandler.SPAWN_EGGS));
    }

    public Component m_7626_(ItemStack stack) {
        Dinosaur dino = this.getDinosaur(stack);
        MutableComponent dinoName = dino.getTranslatedName();
        return Component.m_237110_((String)"item.jurassicreborn.spawn_egg_name", (Object[])new Object[]{dinoName});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            int mode = this.changeMode(stack);
            if (world.f_46443_) {
                String template = LangUtil.translate("item.spawnegg.change_gender");
                String genderText = LangUtil.getGender(mode).getString();
                String msg = template.replace("{mode}", genderText);
                player.m_5661_((Component)Component.m_237113_((String)msg), true);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        double z;
        double y;
        Level world = ctx.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)be;
            Dinosaur type = this.getDinosaur(stack);
            RegistryObject<? extends EntityType<? extends DinosaurEntity>> reg = DinosaurEntity.CLASS_TYPE_LIST.get(type.getDinosaurClass());
            EntityType et = null;
            if (reg != null) {
                et = (EntityType)reg.get();
            } else {
                String base = type.getName().toLowerCase(Locale.ROOT);
                ResourceLocation key = new ResourceLocation("jurassicreborn", base);
                et = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(key);
                if (et == null) {
                    ResourceLocation alt = new ResourceLocation("jurassicreborn", "velociraptor" + base);
                    et = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(alt);
                }
            }
            if (et != null) {
                spawner.m_59801_().m_45462_(et);
                spawner.m_6596_();
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.CONSUME;
        }
        BlockPos spawnPos = pos.m_121945_(ctx.m_43719_());
        double x = (double)spawnPos.m_123341_() + 0.5;
        DinosaurEntity ent = this.spawnDinosaur(world, player, stack, x, y = (double)spawnPos.m_123342_(), z = (double)spawnPos.m_123343_() + 0.5);
        if (ent != null) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            world.m_7967_((Entity)ent);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private DinosaurEntity spawnDinosaur(Level world, Player player, ItemStack stack, double x, double y, double z) {
        Dinosaur type = this.getDinosaur(stack);
        if (type == null) {
            return null;
        }
        RegistryObject<? extends EntityType<? extends DinosaurEntity>> reg = DinosaurEntity.CLASS_TYPE_LIST.get(type.getDinosaurClass());
        EntityType et = null;
        if (reg != null) {
            et = (EntityType)reg.get();
        } else {
            String base = type.getName().toLowerCase(Locale.ROOT);
            ResourceLocation key = new ResourceLocation("jurassicreborn", base);
            et = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(key);
            if (et == null) {
                ResourceLocation alt = new ResourceLocation("jurassicreborn", "velociraptor" + base);
                et = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(alt);
            }
        }
        if (et == null) {
            return null;
        }
        Entity raw = et.m_20615_(world);
        if (!(raw instanceof DinosaurEntity)) {
            return null;
        }
        DinosaurEntity dino = (DinosaurEntity)raw;
        dino.m_6034_(x, y, z);
        dino.m_146922_(world.f_46441_.m_188501_() * 360.0f);
        dino.setGenetics(GeneticsHelper.randomGenetics(world.f_46441_));
        dino.setDNAQuality(100);
        int gender = this.getMode(stack);
        if (gender == 1) {
            dino.setMale(true);
        } else if (gender == 2) {
            dino.setMale(false);
        }
        if (player.m_6144_()) {
            dino.setAge(0);
        }
        return dino;
    }

    private Dinosaur getDinosaur(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        int id = tag != null && tag.m_128441_(TAG_DINO) ? tag.m_128451_(TAG_DINO) : 0;
        return DinosaurHandler.getById(id);
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_(TAG_GENDER);
    }

    private int changeMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int mode = (tag.m_128451_(TAG_GENDER) + 1) % 3;
        tag.m_128405_(TAG_GENDER, mode);
        stack.m_41751_(tag);
        return mode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)LangUtil.translate("lore.spawnegg.use_on_spawner")));
        tooltip.add((Component)Component.m_237113_((String)LangUtil.translate("lore.spawnegg.sneak_to_change_gender")));
        super.m_7373_(stack, world, tooltip, flag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_220152_(group)) {
            return;
        }
        for (int i = 0; i < DinosaurHandler.count(); ++i) {
            ItemStack s = new ItemStack((ItemLike)this);
            if (DinosaurHandler.getById(i) == Dinosaur.EMPTY) continue;
            s.m_41784_().m_128405_(TAG_DINO, i);
            items.add((Object)s);
        }
    }
}

