/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.paleopad.AppHandler;
import net.vit.jurassicreborn.common.paleopad.FeederTrackerApp;
import net.vit.jurassicreborn.common.util.networking.PlayerData;

public class SyncFeederTrackerPacket {
    private final CompoundTag appData;

    public SyncFeederTrackerPacket(CompoundTag appData) {
        this.appData = appData;
    }

    public static void encode(SyncFeederTrackerPacket pkt, FriendlyByteBuf buf) {
        buf.m_130079_(pkt.appData);
    }

    public static SyncFeederTrackerPacket decode(FriendlyByteBuf buf) {
        return new SyncFeederTrackerPacket(buf.m_130260_());
    }

    public static void handle(SyncFeederTrackerPacket pkt, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                SyncFeederTrackerPacket.handleClient(pkt);
            }
        });
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SyncFeederTrackerPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        CompoundTag data = pkt.appData == null ? new CompoundTag() : pkt.appData.m_6426_();
        FeederTrackerApp app = (FeederTrackerApp)AppHandler.INSTANCE.feederTracker;
        app.readAppFromNBT(data);
        PlayerData playerData = PlayerData.get((Player)player);
        playerData.getAppdata().put(app.getName(), data.m_6426_());
    }
}

