/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.vit.jurassicreborn.mixin.accessors.CreativeModeTabAccessor;

public class ItemStackCreativeModeTabSystem {
    public static final HashMap<CreativeModeTab, NonNullList<Supplier<ItemStack>>> TAB_ITEM_SUPPLIER_HASH_MAP = new HashMap();
    public static final HashMap<CreativeModeTab, NonNullList<ItemStack>> TAB_ITEM_HASH_MAP = new LinkedHashMap<CreativeModeTab, NonNullList<ItemStack>>();
    private static boolean applied = false;
    private static final Collector<Supplier<ItemStack>, ?, NonNullList<ItemStack>> collector = new Collector<Supplier<ItemStack>, ArrayList<ItemStack>, NonNullList<ItemStack>>(){

        @Override
        public Supplier<ArrayList<ItemStack>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<ArrayList<ItemStack>, Supplier<ItemStack>> accumulator() {
            return (itemStacks, itemStackSupplier) -> itemStacks.add((ItemStack)itemStackSupplier.get());
        }

        @Override
        public BinaryOperator<ArrayList<ItemStack>> combiner() {
            return (one, two) -> {
                one.addAll(two);
                return one;
            };
        }

        @Override
        public Function<ArrayList<ItemStack>, NonNullList<ItemStack>> finisher() {
            return list -> {
                NonNullList ret = NonNullList.m_122779_();
                for (int i = 0; i < list.size(); ++i) {
                    ret.add(i, (Object)((ItemStack)list.get(i)));
                }
                return ret;
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED));
        }
    };

    @SafeVarargs
    public static void addItemStacksToTab(CreativeModeTab tab, NonNullList<Supplier<ItemStack>> ... stacks) {
        for (NonNullList<Supplier<ItemStack>> stack : stacks) {
            if (TAB_ITEM_SUPPLIER_HASH_MAP.containsKey(tab)) {
                NonNullList<Supplier<ItemStack>> tabMap = TAB_ITEM_SUPPLIER_HASH_MAP.remove(tab);
                NonNullList newTabMap = NonNullList.m_122779_();
                newTabMap.addAll(tabMap);
                newTabMap.addAll(stack);
                TAB_ITEM_SUPPLIER_HASH_MAP.put(tab, (NonNullList<Supplier<ItemStack>>)newTabMap);
            } else {
                TAB_ITEM_SUPPLIER_HASH_MAP.put(tab, stack);
            }
            if (tab == CreativeModeTab.f_40754_) continue;
            ItemStackCreativeModeTabSystem.addItemStacksToTab(CreativeModeTab.f_40754_, stacks);
        }
    }

    public static void apply() {
        if (ItemStackCreativeModeTabSystem.getApplied()) {
            return;
        }
        for (CreativeModeTab key : TAB_ITEM_SUPPLIER_HASH_MAP.keySet()) {
            NonNullList<Supplier<ItemStack>> stackSuppliers = TAB_ITEM_SUPPLIER_HASH_MAP.get(key);
            NonNullList<ItemStack> stacks = ItemStackCreativeModeTabSystem.collect(stackSuppliers);
            TAB_ITEM_HASH_MAP.put(key, stacks);
        }
        applied = true;
    }

    public static boolean getApplied() {
        return applied;
    }

    public static NonNullList<ItemStack> getItemStacksForTab(CreativeModeTab tab) {
        if (!ItemStackCreativeModeTabSystem.getApplied()) {
            ItemStackCreativeModeTabSystem.apply();
            return ItemStackCreativeModeTabSystem.getItemStacksForTab(tab);
        }
        NonNullList stacks = TAB_ITEM_HASH_MAP.get(tab);
        if (stacks == null) {
            stacks = NonNullList.m_122779_();
        }
        return stacks;
    }

    public static void jurassicreborn$fillItemStacks(CreativeModeTab instance, NonNullList<ItemStack> itemStacks) {
        if (instance == CreativeModeTab.f_40754_) {
            ((CreativeModeTabAccessor)instance).jurassicreborn$callFillItemList(itemStacks);
            NonNullList<ItemStack> searchStacks = ItemStackCreativeModeTabSystem.getItemStacksForTab(instance);
            if (!searchStacks.isEmpty()) {
                itemStacks.addAll(searchStacks);
            }
            return;
        }
        NonNullList<ItemStack> stacks = ItemStackCreativeModeTabSystem.getItemStacksForTab(instance);
        instance.m_6151_(stacks);
        if (!stacks.isEmpty()) {
            itemStacks.addAll(stacks);
        }
    }

    public static NonNullList<ItemStack> collect(NonNullList<Supplier<ItemStack>> itemSuppliers) {
        NonNullList<ItemStack> collected = itemSuppliers.stream().collect(collector);
        return collected;
    }
}

