/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.Tags;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.fossil.FossilizedTrackwayBlock;
import net.vit.jurassicreborn.common.blocks.fossil.NestFossilBlock;

public class NestFossilFeature
extends Feature<NoneFeatureConfiguration> {
    public NestFossilFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int nestChance = 100;
        Holder biome = level.m_204166_(origin);
        if (biome.m_203656_(BiomeTags.f_207606_) || biome.m_203656_(BiomeTags.f_207608_) || biome.m_203656_(BiomeTags.f_207607_) || biome.m_203656_(Tags.Biomes.IS_SANDY)) {
            nestChance = 30;
        }
        if (rand.m_188503_(nestChance) != 0) {
            return false;
        }
        int size = rand.m_188503_(3) + 6;
        BlockPos pos = origin.m_7918_(rand.m_188503_(16 - size), rand.m_188503_(20) + 30 - origin.m_123342_(), rand.m_188503_(16 - size));
        BlockState nest = (BlockState)((NestFossilBlock)((Object)ModBlocks.NEST_FOSSIL.get())).m_49966_().m_61124_((Property)NestFossilBlock.VARIANT, (Comparable)Integer.valueOf(rand.m_188503_(3)));
        List<BlockState> trackways = List.of(((FossilizedTrackwayBlock)((Object)ModBlocks.FOSSILIZED_TRACKWAY_RAPTOR.get())).m_49966_(), ((FossilizedTrackwayBlock)((Object)ModBlocks.FOSSILIZED_TRACKWAY_BIPED_SMALL.get())).m_49966_(), ((FossilizedTrackwayBlock)((Object)ModBlocks.FOSSILIZED_TRACKWAY_BIPED_MEDIUM.get())).m_49966_());
        BlockState trackway = trackways.get(rand.m_188503_(trackways.size()));
        if (trackway.m_61138_((Property)DirectionalBlock.f_52588_)) {
            trackway = (BlockState)trackway.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(rand));
        }
        for (int dx = 0; dx < size; ++dx) {
            for (int dz = 0; dz < size; ++dz) {
                BlockPos p = pos.m_7918_(dx, 0, dz);
                BlockState ground = level.m_8055_(p);
                if (ground.m_60795_() || ground.m_60767_().m_76332_()) continue;
                BlockState replace = null;
                if (rand.m_188501_() < 0.8f) {
                    if (rand.m_188501_() < 0.1f) {
                        replace = trackway;
                    } else if (rand.m_188501_() < 0.6f) {
                        replace = Blocks.f_49994_.m_49966_();
                    } else {
                        BlockState blockState = replace = rand.m_188499_() ? Blocks.f_50287_.m_49966_() : Blocks.f_50295_.m_49966_();
                    }
                }
                if (replace == null) continue;
                level.m_7731_(p, replace, 2);
            }
        }
        for (int i = 0; i < rand.m_188503_(2) + 1; ++i) {
            BlockPos p = pos.m_7918_(rand.m_188503_(size), 0, rand.m_188503_(size));
            BlockState ground = level.m_8055_(p);
            if (ground.m_60795_() || ground.m_60767_().m_76332_()) continue;
            level.m_7731_(p, nest, 2);
        }
        return true;
    }
}

