/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CalymeneEntity;

@OnlyIn(value=Dist.CLIENT)
public class CalymeneAnimator
extends EntityAnimator<CalymeneEntity> {
    @Override
    protected void performAnimations(AnimatableModel model, CalymeneEntity entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        float bobDegree;
        boolean swimming;
        AdvancedModelBox root = model.getCube("Trilobite");
        AdvancedModelBox head = model.getCube("Head");
        AdvancedModelBox body1 = model.getCube("Bodyseg1");
        AdvancedModelBox body2 = model.getCube("Bodyseg2");
        AdvancedModelBox body3 = model.getCube("Bodyseg3");
        AdvancedModelBox body4 = model.getCube("Bodyseg4");
        AdvancedModelBox body5 = model.getCube("Bodyseg5");
        AdvancedModelBox eyes = model.getCube("Eyes");
        AdvancedModelBox antennaR = model.getCube("AntennaR");
        AdvancedModelBox antennaL = model.getCube("AntennaL");
        AdvancedModelBox legsL = model.getCube("LegsL");
        AdvancedModelBox legsR = model.getCube("LegsR");
        AdvancedModelBox legsL2 = model.getCube("LegsL2");
        AdvancedModelBox legsR2 = model.getCube("LegsR2");
        AdvancedModelBox legsL3 = model.getCube("LegsL3");
        AdvancedModelBox legsR3 = model.getCube("LegsR3");
        AdvancedModelBox legsL4 = model.getCube("LegsL4");
        AdvancedModelBox legsR4 = model.getCube("LegsR4");
        AdvancedModelBox[] bodyChain = new AdvancedModelBox[]{head, body1, body2, body3, body4, body5};
        AdvancedModelBox[] leftLegs = new AdvancedModelBox[]{legsL, legsL2, legsL3, legsL4};
        AdvancedModelBox[] rightLegs = new AdvancedModelBox[]{legsR, legsR2, legsR3, legsR4};
        if (entity.isCarcass() || !entity.m_6084_()) {
            return;
        }
        boolean onBottom = entity.m_20069_() && entity.isOnBottom();
        boolean bl = swimming = entity.m_20069_() && !onBottom;
        if (entity.isRolled()) {
            float curlSign = -1.0f;
            float curlBase = 0.85f;
            if (head != null) {
                head.rotateAngleX += curlSign * curlBase * 1.1f;
            }
            if (body1 != null) {
                body1.rotateAngleX += curlSign * curlBase * 0.95f;
            }
            if (body2 != null) {
                body2.rotateAngleX += curlSign * curlBase * 0.8f;
            }
            if (body3 != null) {
                body3.rotateAngleX += curlSign * curlBase * 0.8f;
            }
            if (body4 != null) {
                body4.rotateAngleX += curlSign * curlBase * 0.95f;
            }
            if (body5 != null) {
                body5.rotateAngleX += curlSign * curlBase * 1.15f;
            }
            if (antennaR != null) {
                antennaR.rotateAngleX += curlSign * 1.0f;
            }
            if (antennaL != null) {
                antennaL.rotateAngleX += curlSign * 1.0f;
            }
            for (AdvancedModelBox l : leftLegs) {
                if (l == null) continue;
                l.rotateAngleZ += 0.45f;
            }
            for (AdvancedModelBox r : rightLegs) {
                if (r == null) continue;
                r.rotateAngleZ -= 0.45f;
            }
            return;
        }
        float bobSpeed = swimming ? 0.12f : 0.08f;
        float f = bobDegree = swimming ? 0.2f : 0.1f;
        if (root != null) {
            model.bob(root, bobSpeed, bobDegree, false, ticks, 0.25f);
        }
        if (onBottom) {
            model.chainWave(bodyChain, 0.12f, 0.05f, 1.0, ticks, 0.25f);
            model.chainSwing(bodyChain, 0.1f, 0.04f, 2.0, ticks, 0.25f);
            float antSway = (float)Math.sin(ticks * 0.25f) * 0.18f;
            float antNod = (float)Math.sin(ticks * 0.17f) * 0.08f;
            if (antennaR != null) {
                antennaR.rotateAngleY += antSway;
                antennaR.rotateAngleX += antNod;
            }
            if (antennaL != null) {
                antennaL.rotateAngleY += -antSway;
                antennaL.rotateAngleX += antNod * 0.9f;
            }
            float crawlSpeed = 0.9f;
            float crawlDegree = 0.45f;
            float waveOffset = 0.6f;
            float liftFactor = 0.25f;
            model.chainSwing(leftLegs, crawlSpeed, crawlDegree, waveOffset, ticks, 0.5f);
            model.chainSwing(rightLegs, crawlSpeed, crawlDegree, waveOffset, ticks + 3.0f, 0.5f);
            model.chainWave(leftLegs, crawlSpeed, crawlDegree * liftFactor, waveOffset, ticks, 0.5f);
            model.chainWave(rightLegs, crawlSpeed, crawlDegree * liftFactor, waveOffset, ticks + 3.0f, 0.5f);
            if (head != null) {
                head.rotateAngleX += 0.06f;
            }
        } else if (swimming) {
            float swimScale = 0.5f;
            float swimSpeed = 0.45f * swimScale;
            float swimDegree = 0.6f * swimScale;
            model.chainWave(bodyChain, swimSpeed, swimDegree * 0.35f, 2.0, ticks, 0.5f);
            model.chainSwing(bodyChain, swimSpeed, swimDegree * 0.55f, 3.0, ticks, 0.5f);
            if (head != null) {
                head.rotateAngleX += (float)Math.sin(ticks * 0.17f) * (0.1f * swimScale);
            }
            float antSway = (float)Math.sin(ticks * 0.3f) * (0.3f * swimScale);
            float antNod = (float)Math.sin(ticks * 0.22f) * (0.1f * swimScale);
            if (antennaR != null) {
                antennaR.rotateAngleY += antSway;
                antennaR.rotateAngleX += antNod;
            }
            if (antennaL != null) {
                antennaL.rotateAngleY += -antSway;
                antennaL.rotateAngleX += antNod * 0.9f;
            }
            float rowSpeed = 0.55f * swimScale;
            float rowDegree = 0.55f * swimScale;
            model.chainSwing(leftLegs, rowSpeed, rowDegree * 0.55f, 2.0, ticks, 0.6f);
            model.chainWave(leftLegs, rowSpeed, rowDegree * 0.25f, 1.0, ticks, 0.6f);
            model.chainSwing(rightLegs, rowSpeed, rowDegree * 0.55f, 2.0, ticks + 4.0f, 0.6f);
            model.chainWave(rightLegs, rowSpeed, rowDegree * 0.25f, 1.0, ticks + 4.0f, 0.6f);
        } else {
            float idleSpeed = 0.12f;
            float idleDegree = 0.15f;
            float legSpd = 0.18f;
            float legDeg = 0.2f;
            model.chainWave(bodyChain, idleSpeed, idleDegree * 0.7f, 2.0, ticks, 0.25f);
            model.chainSwing(bodyChain, idleSpeed, idleDegree * 0.4f, 3.0, ticks, 0.25f);
            if (head != null) {
                head.rotateAngleX += (float)Math.sin(ticks * 0.07f) * 0.02f;
            }
            if (eyes != null) {
                eyes.rotateAngleY += (float)Math.sin(ticks * 0.11f) * 0.015f;
            }
            float antSway = (float)Math.sin(ticks * 0.16f) * 0.25f;
            float antNod = (float)Math.sin(ticks * 0.12f) * 0.08f;
            if (antennaR != null) {
                antennaR.rotateAngleY += antSway;
                antennaR.rotateAngleX += antNod;
            }
            if (antennaL != null) {
                antennaL.rotateAngleY += -antSway;
                antennaL.rotateAngleX += antNod * 0.9f;
            }
            model.chainWave(leftLegs, legSpd, legDeg * 0.15f, 1.0, ticks, 0.15f);
            model.chainSwing(leftLegs, legSpd, legDeg * 0.2f, 2.0, ticks, 0.15f);
            model.chainWave(rightLegs, legSpd, legDeg * 0.15f, 1.0, ticks + 5.5f, 0.15f);
            model.chainSwing(rightLegs, legSpd, legDeg * 0.2f, 2.0, ticks + 5.5f, 0.15f);
        }
    }
}

