/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DunkleosteusEntity;

@OnlyIn(value=Dist.CLIENT)
public class DunkleosteusAnimator
extends EntityAnimator<DunkleosteusEntity> {
    @Override
    protected void performAnimations(AnimatableModel model, DunkleosteusEntity entity, float f, float f1, float ticks, float rotationYaw, float rotationPitch, float scale) {
        AdvancedModelBox head = model.getCube("Head");
        AdvancedModelBox jaw = model.getCube("Jaw");
        AdvancedModelBox body = model.getCube("Body");
        AdvancedModelBox body2 = model.getCube("Body2");
        AdvancedModelBox body3 = model.getCube("Body3");
        AdvancedModelBox tail1 = model.getCube("Tail1");
        AdvancedModelBox tail2 = model.getCube("Tail2");
        AdvancedModelBox leftFrontFlipper = model.getCube("LeftFrontFlipper");
        AdvancedModelBox rightFrontFlipper = model.getCube("RightFrontFlipper");
        AdvancedModelBox middleLeftFlipper = model.getCube("MiddleLeftFlipper");
        AdvancedModelBox middleRightFlipper = model.getCube("MiddleRightFlipper");
        AdvancedModelBox backLeftFlipper = model.getCube("BackLeftFlipper");
        AdvancedModelBox backRightFlipper = model.getCube("BackRightFlipper");
        AdvancedModelBox[] tail = new AdvancedModelBox[]{tail2, tail1};
        AdvancedModelBox[] spine = new AdvancedModelBox[]{body3, body2, body};
        boolean inWater = entity.m_20069_();
        float swimSpeed = 0.26f;
        float swimDegree = 0.14f;
        float waveFactor = 0.08f;
        float bobSpeed = 0.18f;
        float bobDegree = 0.035f;
        float flopSpeed = 0.3f;
        float flopDegree = 0.12f;
        if (body != null) {
            model.bob(body, inWater ? bobSpeed : 0.45f, inWater ? bobDegree : 0.1f, false, ticks, 1.0f);
        }
        if (inWater) {
            model.chainSwing(tail, swimSpeed, swimDegree, 2.0, ticks, 1.0f);
            model.chainWave(tail, swimSpeed * 0.55f, swimDegree * waveFactor, 2.0, ticks, 1.0f);
            model.chainSwing(spine, swimSpeed * 0.7f, -swimDegree * 0.2f, 2.0, ticks + 0.5f, 0.9f);
            DunkleosteusAnimator.flapPair(leftFrontFlipper, rightFrontFlipper, 0.44f, 0.1f, ticks);
            DunkleosteusAnimator.flapPair(middleLeftFlipper, middleRightFlipper, 0.4f, 0.09f, ticks + 0.25f);
            DunkleosteusAnimator.flapPair(backLeftFlipper, backRightFlipper, 0.37f, 0.08f, ticks + 0.5f);
        } else {
            model.chainSwing(tail, flopSpeed, flopDegree, 2.0, ticks, 1.0f);
            model.chainSwing(spine, flopSpeed * 0.7f, -flopDegree * 0.18f, 2.0, ticks, 0.9f);
            if (leftFrontFlipper != null) {
                leftFrontFlipper.rotateAngleZ -= 0.22f;
                leftFrontFlipper.rotateAngleX += 0.15f;
            }
            if (rightFrontFlipper != null) {
                rightFrontFlipper.rotateAngleZ += 0.22f;
                rightFrontFlipper.rotateAngleX += 0.15f;
            }
            if (middleLeftFlipper != null) {
                middleLeftFlipper.rotateAngleZ -= 0.18f;
            }
            if (middleRightFlipper != null) {
                middleRightFlipper.rotateAngleZ += 0.18f;
            }
            if (backLeftFlipper != null) {
                backLeftFlipper.rotateAngleZ -= 0.14f;
            }
            if (backRightFlipper != null) {
                backRightFlipper.rotateAngleZ += 0.14f;
            }
        }
        if (head != null) {
            float damp = 0.3f;
            model.faceTarget(rotationYaw * damp, rotationPitch * damp, 0.35f, head);
            float maxYaw = (float)Math.toRadians(10.0);
            float maxPitch = (float)Math.toRadians(8.0);
            if (head.rotateAngleY > maxYaw) {
                head.rotateAngleY = maxYaw;
            }
            if (head.rotateAngleY < -maxYaw) {
                head.rotateAngleY = -maxYaw;
            }
            if (head.rotateAngleX > maxPitch) {
                head.rotateAngleX = maxPitch;
            }
            if (head.rotateAngleX < -maxPitch) {
                head.rotateAngleX = -maxPitch;
            }
        }
    }

    private static void flapPair(AdvancedModelBox left, AdvancedModelBox right, float freq, float amp, float t) {
        if (left != null && right != null) {
            float s = (float)Math.sin(t * freq);
            float c = (float)Math.cos(t * freq);
            left.rotateAngleZ += s * (amp * 0.65f) - 0.18f;
            right.rotateAngleZ += -s * (amp * 0.65f) + 0.18f;
            left.rotateAngleX += c * (amp * 0.2f);
            right.rotateAngleX += -c * (amp * 0.2f);
        }
    }
}

