/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LivyatanEntity;

@OnlyIn(value=Dist.CLIENT)
public class LivyatanAnimator
extends EntityAnimator<LivyatanEntity> {
    @Override
    protected void performAnimations(AnimatableModel model, LivyatanEntity entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        float intensity;
        AdvancedModelBox body = model.getCube("Body");
        AdvancedModelBox shoulders = model.getCube("Shoulders");
        AdvancedModelBox neck = model.getCube("Neck");
        AdvancedModelBox head = model.getCube("Head");
        AdvancedModelBox jaw = model.getCube("Jaw");
        AdvancedModelBox leftFlipper = model.getCube("LeftFlipper");
        AdvancedModelBox rightFlipper = model.getCube("RightFlipper");
        boolean inWater = entity.m_20069_();
        if (entity.isCarcass()) {
            return;
        }
        if (inWater) {
            float speed = Mth.m_14116_((float)((float)entity.m_20184_().m_82556_()));
            intensity = Math.max(0.18f, speed * 2.5f) * 0.5f;
        } else {
            intensity = 0.12f;
        }
        if (body != null) {
            float bobFreq = 0.25f + 0.25f * intensity;
            float bobAmp = 0.06f + 0.06f * intensity;
            model.bob(body, bobFreq, bobAmp, false, ticks, 1.0f);
        }
        if (neck != null && head != null) {
            float neckPhase = ticks * (0.18f + 0.12f * intensity);
            float s = Mth.m_14031_((float)neckPhase);
            float lead = s * (0.04f * intensity);
            neck.rotateAngleX += -lead * 0.5f;
            head.rotateAngleX += lead;
        }
        if (jaw != null) {
            boolean hunting = entity.m_5448_() != null || intensity > 0.8f;
            float base = inWater ? 0.04f : 0.0f;
            float extra = hunting ? 0.18f : 0.06f * intensity;
            float s = 0.5f + 0.5f * Mth.m_14031_((float)(ticks * 0.9f));
            jaw.rotateAngleX += base + extra * s;
        }
        if (leftFlipper != null && rightFlipper != null) {
            float paddleFreq = (0.8f + intensity * 0.7f) * 0.1f;
            float phase = ticks * paddleFreq;
            float s = Mth.m_14031_((float)phase);
            float c = Mth.m_14089_((float)phase);
            float paddleZ = 0.3f + 0.25f * intensity;
            float paddleX = 0.12f + 0.1f * intensity;
            leftFlipper.rotateAngleZ += s * paddleZ - 0.35f;
            rightFlipper.rotateAngleZ += -s * paddleZ + 0.35f;
            leftFlipper.rotateAngleX += c * paddleX;
            rightFlipper.rotateAngleX += -c * paddleX;
            float steer = rotationYaw * 0.0025f;
            leftFlipper.rotateAngleY += -steer * 0.6f;
            rightFlipper.rotateAngleY += steer * 0.6f;
            if (!inWater) {
                leftFlipper.rotateAngleZ -= 0.35f;
                rightFlipper.rotateAngleZ += 0.35f;
            }
        }
    }
}

